// Переменные для отслеживания состояния кнопок
var isBold = false;
var isItalic = false;
var isUnderline = false;

// Переменная для хранения истории изменений
var textHistory = [];

// Функция для кнопки "Pievienot"
function addContent() {
    // Пример: добавление текста в основное окно записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    textarea.value += "Teksts pievienots. ";
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Atsaukt rakstīšanu"
function undo() {
    var textarea = document.querySelector('.main-entry textarea');
    if (textHistory.length > 0) {
        textarea.value = textHistory.pop(); // Получаем предыдущее состояние текста и устанавливаем его в текстовое поле
    }
}

// Функция для кнопки "Atkārtot rakstīšanu"
function redo() {
    var textarea = document.querySelector('.main-entry textarea');
    // Проверяем, есть ли что-то в истории изменений и есть ли что-то для восстановления
    if (textHistory.length > 0) {
        var nextText = textHistory[textHistory.length - 1]; // Получаем следующее состояние текста
        textarea.value = nextText; // Устанавливаем следующее состояние текста в текстовое поле
    }
}

// Функция для обновления истории изменений
function updateHistory() {
    var textarea = document.querySelector('.main-entry textarea');
    textHistory.push(textarea.value); // Добавляем текущее состояние текста в историю изменений
}

// Функция для кнопки "Regulēt fonta izmēru"
function changeFontSize() {
    // Пример: изменяем размер шрифта в основном окне записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    textarea.style.fontSize = "24px";
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Regulēt fonta krāsu"
function changeFontColor() {
    // Запрашиваем у пользователя выбор цвета
    var color = prompt("Lūdzu, izvēlieties fonta krāsu:", "#000000"); // По умолчанию черный цвет

    // Если пользователь выбрал цвет и нажал "OK"
    if (color !== null) {
        var textarea = document.querySelector('.main-entry textarea');
        textarea.style.color = color;
        updateHistory(); // Обновляем историю изменений
    }
}

// Функция для кнопки "Treknrakstā"
function makeTextBold() {
    // Пример: делаем текст жирным в основном окне записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    if (!isBold) {
        textarea.style.fontWeight = "bold";
        isBold = true;
    } else {
        textarea.style.fontWeight = "normal";
        isBold = false;
    }
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Slīpraksta"
function makeTextItalic() {
    // Пример: делаем текст курсивом в основном окне записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    if (!isItalic) {
        textarea.style.fontStyle = "italic";
        isItalic = true;
    } else {
        textarea.style.fontStyle = "normal";
        isItalic = false;
    }
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Pasvītrot"
function underlineText() {
    // Пример: подчеркиваем текст в основном окне записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    if (!isUnderline) {
        textarea.style.textDecoration = "underline";
        isUnderline = true;
    } else {
        textarea.style.textDecoration = "none";
        isUnderline = false;
    }
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Saglabāt"
function saveChanges() {
    // Пример: сохраняем содержимое основного окна записи дневника в локальное хранилище
    var textarea = document.querySelector('.main-entry textarea');
    localStorage.setItem('diaryEntry', textarea.value);
}

// Функция для кнопки "Nodzēst ierakstu"
function deleteEntry() {
    // Пример: очищаем основное окно записи дневника
    var textarea = document.querySelector('.main-entry textarea');
    textarea.value = '';
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопок "Iepriešējais ieraksts"
function loadPastEntry(index) {
    // Пример: загружаем предыдущую запись из массива pastEntries по индексу
    var pastEntries = ["Iepriekšējais ieraksts 1", "Iepriekšējais ieraksts 2", "Iepriekšējais ieraksts 3", "Iepriekšējais ieraksts 4", "Iepriekšējais ieraksts 5"];
    var textarea = document.querySelector('.main-entry textarea');
    textarea.value = pastEntries[index - 1];
    updateHistory(); // Обновляем историю изменений
}

// Функция для кнопки "Atrast ierakstu"
function findEntry() {
    // Пример: открываем модальное окно с формой для поиска записи
    alert('Функционал для поиска записи');
}

// Добавляем обработчик события input для обновления истории изменений при вводе текста
var textarea = document.querySelector('.main-entry textarea');
textarea.addEventListener('input', updateHistory);
