<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiaryEntry extends Model
{
    use HasFactory;

    protected $table = 'da_diary_entry';

    protected $primaryKey = 'entry_id';

    protected $fillable = [
        'user_id',
        'title',
        'content',
        'creation_date',
    ];

    protected $dates = [
        'creation_date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
