<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\DaUser;

class RegisterController extends Controller
{
    public function showRegistrationForm()
    {
        return view('registret_kontu');
    }

    public function processRegistration(Request $request)
    {
        $request->validate([
            'lietotajvards' => 'required|string|max:255',
            'epasts' => 'required|email|unique:da_users,email',
            'parole' => 'required|string|min:6',
        ]);

        $user = DaUser::create([
            'username' => $request->lietotajvards,
            'email' => $request->epasts,
            'password' => Hash::make($request->parole),
        ]);

        if ($user) {
            return redirect()->route('authentication')->with('success', 'Konts izveidots veiksmīgi! Lūdzu, pieteikties.');
        } else {
            return back()->withInput()->with('error', 'Kļūda, mēģiniet vēlreiz!');
        }
    }
}
