<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\DaUser;

class AuthenticationController extends Controller
{
    public function showLoginForm()
    {
        return view('autentificet');
    }

    public function authenticate(Request $request)
    {
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) {
            return redirect()->route('lietotaja_interfeiss');
        }

        return back()->withErrors(['email' => 'Nepareizs e-pasts vai parole.']);
    }

    public function showUserInterface()
    {
        return view('lietotaja_interfeiss');
    }

    public function logout()
    {
        Auth::logout();
        return redirect('/');
    }
}
