<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja interfeiss</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        .top-right {
            position: absolute;
            top: 10px;
            right: 10px;
        }

        .find-entry {
            position: absolute;
            top: 50px;
            left: 50%;
            transform: translateX(-50%);
        }

        .entries {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 20px;
        }

        .entry-row {
            display: flex;
            margin-bottom: 10px;
        }

        .button {
            padding: 10px;
            margin: 5px;
            border: none;
            cursor: pointer;
        }

        .search-container {
            margin-bottom: 20px;
        }

        #datepicker {
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="top-right">
    <button onclick="finishWork()">Beigt darbu</button>
</div>

<div class="search-container">
    <label for="datepicker">Izvēlies datumu:</label>
    <input type="text" id="datepicker" name="date">
    <button onclick="searchByDate()">Meklēt</button>
</div>

<div class="entries">
    <div class="entry-row">
        <button onclick="createNewEntry()">Izveidot jaunu ierakstu</button>
        <button onclick="loadPastEntry(1)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(2)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(3)">Iepriekšējais ieraksts</button>
    </div>
    <div class="entry-row">
        <button onclick="loadPastEntry(4)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(5)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(6)">Iepriekšējais ieraksts</button>
        <button onclick="loadPastEntry(7)">Iepriekšējais ieraksts</button>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
<script>
    $(function() {
        $("#datepicker").datepicker({
            dateFormat: "yy-mm-dd"
        });
    });

    function finishWork() {
        console.log("Beidzam darbu");
        window.location.href = "<?php echo e(route('lietotaja_interfeiss_buttons')); ?>";
    }

    function createNewEntry() {
        console.log("Izveidojam jaunu ierakstu");
        window.location.href = "<?php echo e(route('entry_creation_page')); ?>";
    }

    function loadPastEntry(entryNumber) {
        console.log("Atveram iepriekšējo ierakstu Nr. " + entryNumber);
    }

    function searchByDate() {
        const date = $('#datepicker').val();
        if (date) {
            window.location.href = `/search_entries?date=${date}`;
        } else {
            alert('Lūdzu, izvēlies datumu!');
        }
    }
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\eikt410\resources\views/lietotaja_interfeiss.blade.php ENDPATH**/ ?>