<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;

// Маршрут для показа формы регистрации
Route::get('/register', [RegisteredUserController::class, 'create'])->name('registration');

// Маршрут для отправки данных формы регистрации
Route::post('/register', [RegisteredUserController::class, 'store'])->name('register.submit');

// Маршрут для показа формы авторизации
Route::get('/login', [AuthenticatedSessionController::class, 'create'])->name('authentication');

// Маршрут для отправки данных формы авторизации
Route::post('/login', [AuthenticatedSessionController::class, 'store'])->name('authenticate');

// Маршрут для кнопочной страницы (страница приветствия)
Route::get('/', function () {
    return view('welcome');
})->name('welcome');
