<!-- resources/views/search_results.blade.php -->

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meklēšanas rezultāti</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
</head>
<body>

<div class="container">
    <h1 class="mt-5">Meklēšanas rezultāti</h1>
    
    @if($entries->isEmpty())
        <p class="alert alert-warning">Nav atrasti ieraksti šajā datumā.</p>
    @else
        <ul class="list-group">
            @foreach($entries as $entry)
                <li class="list-group-item">{{ $entry->title }} - {{ $entry->created_at }}</li>
            @endforeach
        </ul>
    @endif

    <button onclick="goBack()" class="btn btn-primary mt-3">Atpakaļ</button>
</div>

<script>
    function goBack() {
        window.history.back();
    }
</script>

</body>
</html>
