<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ieraksta izveide</title>
    <style>
        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 50vh;
            margin: 100;
        }

        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 80%;
            margin-top: 5px;
        }

        .top-buttons {
            display: flex;
            flex-direction: row;
            gap: 15px;
            margin-top: 20px;
        }

        .top-buttons button {
            font-size: 20px;
            padding: 15px 20px;
            height: auto;
        }

        .entry-title,
        .main-entry {
            margin-top: 20px;
        }

        .past-entries {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
            margin-top: 20px;
        }

        .past-entries button {
            font-size: 20px;
            padding: 15px 20px;
            height: auto;
        }
    </style>
</head>
<body>

<div class="container">


    <div class="top-buttons">
        <button title="Pievienot" onclick="addContent()">➕</button>
        <button title="Atsaukt rakstīšanu" onclick="undo()">↩️</button>
        <button title="Atkārtot rakstīšanu" onclick="redo()">↪️</button>
        <button title="Regulēt fonta izmēru" onclick="changeFontSize()">T</button>
        <button title="Regulēt fonta krāsu" onclick="changeFontColor()">A</button>
        <button title="Treknrakstā" onclick="makeTextBold()">B</button>
        <button title="Slīpraksta" onclick="makeTextItalic()">I</button>
        <button title="Pasvītrot" onclick="underlineText()">U</button>
        <button title="Saglabāt" onclick="saveChanges()">💾</button>
        <button title="Nodzēst ierakstu" onclick="deleteEntry()">🗑️</button>
    </div>


    <div class="past-entries">
        <button onclick="loadPastEntry(1)">Iepriešējais ieraksts</button>
        <button onclick="loadPastEntry(2)">Iepriešējais ieraksts</button>
        <button onclick="loadPastEntry(3)">Iepriešējais ieraksts</button>
        <button onclick="loadPastEntry(4)">Iepriešējais ieraksts</button>
        <button onclick="loadPastEntry(5)">Iepriešējais ieraksts</button>
    </div>

</div>


<div class="entry-title">
    <input type="text" placeholder="Ievadiet virsrakstu">
</div>

<div class="main-entry">
    <textarea placeholder="Sāciet rakstīt savu ierakstu šeit..."></textarea>
</div>


<script src="script.js"></script>

</body>
</html>
