<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lietotāja reģistrācija</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
        }

        .form-container {
            max-width: 400px;
            width: 100%;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        .form-container label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
        }

        .form-container input {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
            box-sizing: border-box;
        }

        .button-container {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .button-container button {
            background-color: #4caf50;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .button-container button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<div class="form-container">
    <form method="POST" action="{{ route('register.submit') }}">
        @csrf
        <label for="name">Lietotājvārds</label>
        <input type="text" id="name" name="name" placeholder="Lietotājvārds" value="{{ old('name') }}" required autofocus>
        
        <label for="email">E-pasts</label>
        <input type="email" id="email" name="email" placeholder="E-pasts" value="{{ old('email') }}" required>
        
        <label for="password">Parole</label>
        <input type="password" id="password" name="password" placeholder="Parole" required>

        <label for="password_confirmation">Apstipriniet paroli</label>
        <input type="password" id="password_confirmation" name="password_confirmation" placeholder="Apstipriniet paroli" required>

        <div class="button-container">
            <button type="submit">Izveidot kontu</button>
            <button type="button" onclick="goBack()">Atpakaļ</button>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger mt-3">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function goBack() {
        window.history.back();
    }
</script>

</body>
</html>
