<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDaDiaryEntryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('da_diary_entry', function (Blueprint $table) {
            $table->id('entry_id')->unsigned()->comment('Unikāls ieraksta identifikators');
            $table->unsignedBigInteger('user_id')->comment('Lietotāja identifikators');
            $table->foreign('user_id')->references('id')->on('da_users')->onUpdate('cascade')->onDelete('cascade');
            $table->string('title', 255)->comment('Ieraksta virsraksts');
            $table->text('content')->comment('Ieraksta saturs');
            $table->timestamp('creation_date')->default(DB::raw('CURRENT_TIMESTAMP'))->comment('Ieraksta izveidošanas datums un laiks');
            $table->timestamps();
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('da_diary_entry');
    }
}
