<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ieraksta izveide</title>
    <style>
        body {
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background-color: #f0f0f0;
}
.container {
display: flex;
flex-direction: column;
align-items: center;
justify-content: center;
width: 95%;
height: 95%;
max-width: 1000px;
background-color: #fff;
padding: 20px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

.top-buttons {
display: flex;
flex-wrap: wrap;
gap: 10px;
margin-bottom: 10px;
justify-content: center;
align-items: center;
background-color: transparent;
}

.top-buttons button {
display: flex;
align-items: center;
justify-content: center;
font-size: 20px;
width: 50px;
height: 50px;
background-color: #eee;
border: 1px solid #ccc;
cursor: pointer;
box-sizing: border-box;
}

.top-buttons label {
display: flex;
align-items: center;
justify-content: center;
font-size: 20px;
width: 50px;
height: 50px;
background-color: #eee;
border: 1px solid #ccc;
cursor: pointer;
box-sizing: border-box;
margin-top: 10px;
}

.entry-title,
.main-entry {
margin-bottom: 20px;
width: 100%;
text-align: center;
}

.entry-title input {
width: 100%;
max-width: 400px;
padding: 8px;
margin-bottom: 10px;
box-sizing: border-box;
text-align: center;
border: 1px solid #ccc;
font-size: 24px;
}

.main-entry div {
width: 100%;
max-width: 800px;
min-height: 600px;
overflow-y: auto;
border: 1px solid #000;
padding: 5px;
box-sizing: border-box;
text-align: left;
margin-left: auto;
margin-right: auto;
font-size: 16px;
}

#imgInput {
display: none;
}

.add-image-button {
background-color: transparent;
border: none;
cursor: pointer;
font-size: 20px;
}

.add-image-button
{
background-color: #ddd;
}

.top-buttons button
,
.top-buttons label
{
filter: brightness(85%); /* Уменьшаем яркость кнопки при наведении */
}

#font-size-controls {
display: flex;
align-items: center;
justify-content: center;
gap: 10px;
}

#font-size-display {
font-size: 20px;
width: 50px;
text-align: center;
}

.font-size-control-button {
cursor: pointer;
padding: 5px 10px;
border: none;
background-color: #ddd;
font-size: 20px;
}

#colorPalette {
display: none;
position: absolute;
top: 50px;
left: 50%;
transform: translateX(-50%);
background-color: #fff;
border: 1px solid #ccc;
padding: 10px;
box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
z-index: 1000;
}

.color-swatch {
width: 30px;
height: 30px;
display: inline-block;
margin: 5px;
cursor: pointer;
}

.color-swatch.red { background-color: red; }
.color-swatch.blue { background-color: blue; }
.color-swatch.green { background-color: green; }
.color-swatch.yellow { background-color: yellow; }
.color-swatch.purple { background-color: purple; }
.color-swatch.black { background-color: black; }

.color-input-container {
display: flex;
align-items: center;
margin-top: 10px;
}

.color-input-container input {
margin-left: 10px;
padding: 5px;
font-size: 16px;
width: 100px;
text-transform: uppercase;
}

.apply-color-button {
margin-left: 10px;
padding: 5px 10px;
cursor: pointer;
border: none;
background-color: #ddd;
font-size: 16px;
}
</style>

</head>
<body>
<div class="container">
    <div class="top-buttons">
        <button onclick="goToDashboard()" title="Atpakaļ uz paneli">←</button>
        <label for="imgInput" id="imgLabel" class="top-buttons add-image-button" title="Pievienot">➕</label>
        <input type="file" id="imgInput" accept="image/*" onchange="addImage(event)">
        <button title="Atsaukt rakstīšanu" onclick="undo()">↩️</button>
        <button title="Atkārtot rakstīšanu" onclick="redo()">↪️</button>
        <div id="font-size-controls">
            <input type="number" id="font-size-display" value="16" onchange="changeFontSize()">
        </div>
        <button title="Regulēt fonta krāsu" onclick="toggleColorPalette()">A</button>
        <button title="Treknrakstā" onclick="makeTextBold()">B</button>
        <button title="Slīpraksts" onclick="makeTextItalic()">I</button>
        <button title="Pasvītrot" onclick="underlineText()">U</button>
        <button title="Saglabāt" onclick="saveChanges()">💾</button>
        <button title="Nodzēst ierakstu" onclick="deleteEntry()">🗑️</button>
    </div>

<div class="entry-title">
    <form method="POST" action="<?php echo e(route('save_diary_entry')); ?>">
        <?php echo csrf_field(); ?>
        <label for="title"></label>
        <input type="text" id="title" name="title" placeholder="Ievadiet virsrakstu">
    </form>
</div>

<div id="mainDiv" contenteditable="true" placeholder="Kā pagāja diena?" style="font-size: 16px; border: 1px solid #ccc; width: 90%; height: 700px; overflow-y: auto;"></div>

<div id="colorPalette">
    <div class="color-swatch red" onclick="changeFontColor('red')"></div>
    <div class="color-swatch blue" onclick="changeFontColor('blue')"></div>
    <div class="color-swatch green" onclick="changeFontColor('green')"></div>
    <div class="color-swatch yellow" onclick="changeFontColor('yellow')"></div>
    <div class="color-swatch purple" onclick="changeFontColor('purple')"></div>
    <div class="color-swatch black" onclick="changeFontColor('black')"></div>

    <div class="color-input-container">
        <input type="text" id="colorInput" placeholder="HEX">
        <button class="apply-color-button" onclick="applyCustomColor()">Применить</button>
    </div>
</div>

<script>

function goToDashboard() {
    window.location.href = "<?php echo e(route('dashboard')); ?>";
}

var textHistory = [];
var historyIndex = -1;

function addContent() {
    var div = document.getElementById('mainDiv');
    div.innerHTML += "Teksts pievienots. ";
    updateHistory(); 
}

function undo() {
            document.execCommand('undo');
        }

function redo() {
            document.execCommand('redo');
        }


function updateHistory() {
    var div = document.getElementById('mainDiv');
    historyIndex++;
    console.log("Updating history. History Index: ", historyIndex);
    textHistory.splice(historyIndex); // Remove items after current historyIndex
    textHistory.push({
        content: div.innerHTML,
        images: Array.from(div.querySelectorAll('img')).map(img => img.src)
    });
    console.log("Updated Text History: ", textHistory);
}

function changeFontSize() {
    var div = document.getElementById('mainDiv');
    var size = document.getElementById('font-size-display').value;
    if (size >= 13 && size <= 35) {
        div.style.fontSize = size + 'px';
        updateHistory();
    } else if (size < 13) {
        div.style.fontSize = '13px';
        document.getElementById('font-size-display').value = 13;
        updateHistory();
    } else {
        div.style.fontSize = '35px';
        document.getElementById('font-size-display').value = 35;
        updateHistory();
    }
}

function increaseFontSize() {
    var fontSizeDisplay = document.getElementById('font-size-display');
    var size = parseFloat(fontSizeDisplay.value) + 1;
    if (size <= 35) {
        fontSizeDisplay.value = size;
        changeFontSize();
    }
}

function decreaseFontSize() {
    var fontSizeDisplay = document.getElementById('font-size-display');
    var size = parseFloat(fontSizeDisplay.value) - 1;
    if (size >= 13) {
        fontSizeDisplay.value = size;
        changeFontSize();
    }
}


function toggleColorPalette() {
    var palette = document.getElementById('colorPalette');
    palette.style.display = (palette.style.display === 'none' || palette.style.display === '') ? 'block' : 'none';
}

function changeFontColor(color) {
    var div = document.getElementById('mainDiv');
    div.style.color = color;
    toggleColorPalette();
}

function applyCustomColor() {
    var color = document.getElementById('colorInput').value;
    if (/^#[0-9A-F]{6}$/i.test(color)) {
        changeFontColor(color);
    } else {
        alert('Lūdzu, ievadiet derīgu HEX kodu.');
    }
}

function ensureHashPrefix() {
    var input = document.getElementById('colorInput');
    if (!input.value.startsWith('#')) {
        input.value = '#' + input.value.replace(/#/g, '');
    }
}

function makeTextBold() {
    document.execCommand('bold', false, null);
    updateHistory();
}

function makeTextItalic() {
    document.execCommand('italic', false, null);
    updateHistory();
}

function underlineText() {
    document.execCommand('underline', false, null);
    updateHistory();
}

function saveChanges() {
    var titleInput = document.querySelector('.entry-title input');
    var title = titleInput.value;
    var content = document.getElementById('mainDiv').innerHTML;

    if (!title.trim() || !content.trim()) {
        alert('Please enter a title and content for the diary entry.');
        return;
    }

    var data = {
        title: title,
        content: content
    };

    fetch('https://is-projekts.id.lv/jt/doc/2024/ALEKPEROVS_DANIELS/eikt410/public/index.php/save-diary-entry', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': 'tdNzdBzmjFaAap1FKkW1pGDJe6ErCChTCS6472Gy'
        },
        body: JSON.stringify(data)
    })
    .then(response => {
        if (response.ok) {
            alert('Diary entry saved successfully.');
            // Optionally, you can redirect the user to another page after saving
            window.location.href = 'https://is-projekts.id.lv/jt/doc/2024/ALEKPEROVS_DANIELS/eikt410/public/index.php';
        } else {
            throw new Error('Failed to save diary entry.');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Failed to save diary entry. Please try again.');
    });
}

function deleteEntry() {
    var div = document.getElementById('mainDiv');
    div.innerHTML = '';
    updateHistory();
}

function addImage(event) {
    var files = event.target.files;
    var div = document.getElementById('mainDiv');

    for (var i = 0; i < files.length; i++) {
        (function(i) {
            var file = files[i];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var imgSrc = e.target.result;
                    var img = document.createElement('img');
                    img.src = imgSrc;
                    div.appendChild(img);
                    updateHistory(); // Update history when an image is added
                };
                reader.readAsDataURL(file);
            }
        })(i);
    }

    event.target.value = '';
}

function updateHistoryWithImage(imgSrc) {
    historyIndex++;
    history[historyIndex] = {
        content: document.getElementById('mainDiv').innerHTML,
        image: imgSrc // Store the image source along with the content
    };
    history.splice(historyIndex + 1);
}


document.getElementById('mainDiv').addEventListener('keydown', function(event) {
    if (event.key === 'Enter') {
        event.preventDefault();
        document.execCommand('insertHTML', false, '<br><br>');
    }
});

var div = document.getElementById('mainDiv');
div.addEventListener('input', updateHistory);
div.addEventListener('DOMNodeInserted', updateHistory); // Capture image insertions

document.getElementById('imgInput').addEventListener('change', addImage);
document.getElementById('mainDiv').addEventListener('input', updateHistory);

</script>
</body>
</html><?php /**PATH C:\xampp\htdocs\danielspke\resources\views/entry.blade.php ENDPATH**/ ?>