<?php

use App\Models\Entry;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\EntryController;

Route::get('/', function () {
    return view('welcome');
})->name('welcome');

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::get('/lietotaja_interfeiss_buttons', function () {
        return view('lietotaja_interfeiss_buttons');
    })->name('lietotaja_interfeiss_buttons');

    Route::get('/entry_creation_page', function () {
        return view('entry');
    })->name('entry_creation_page');

    Route::get('/all-entries', [EntryController::class, 'allEntries'])->name('all_entries');

    Route::get('/search_entries', [EntryController::class, 'searchEntries'])->name('search_entries');

    // Define the route to save diary entries
    Route::post('/save-diary-entry', [EntryController::class, 'saveDiaryEntry'])->name('save_diary_entry');
});

require __DIR__.'/auth.php';
