<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>E-dienasgrāmata</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <!-- Styles -->
    <style>
        body {
            font-family: 'Nunito', sans-serif;
        }

        .button-container {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .button-container a.btn {
            background-color: #4caf50;
            color: white;
            padding: 20px 30px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            margin: 0 10px;
            font-size: 18px;
            text-decoration: none; /* убрать подчёркивание ссылок */
        }

        .button-container a.btn:hover {
            background-color: #45a049;
        }

        .title-container {
            text-align: center;
            margin-top: 90px;
        }

        .title-container h1 {
            font-size: 4rem; /* возвращаем больший размер заголовка */
        }
    </style>
</head>
<body>
    <div class="container text-center">
        <div class="row">
            <div class="col-12">
                <div class="title-container">
                    <h1 class="display-1">E-dienasgrāmata</h1>
                </div>
                <div class="button-container">
                    @if (Route::has('login'))
                        @auth
                            <a href="{{ url('/dashboard') }}" class="btn btn-primary">Dashboard</a>
                        @else
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}" class="btn btn-success">Register</a>
                            @endif
                            <a href="{{ route('login') }}" class="btn btn-success">Log in</a>
                        @endauth
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS (Optional, for Bootstrap components if needed) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+Xlf9dWPVx3XvL40tQ9HvyWw5yT4M" crossorigin="anonymous"></script>
</body>
</html>
