<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ieraksta izveide</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f0f0f0;
        }
        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 95%;
            height: 95%;
            max-width: 1000px;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 10px;
            justify-content: center;
            align-items: center;
            background-color: transparent;
        }
        .top-buttons button {
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            width: 50px;
            height: 50px;
            background-color: #eee;
            border: 1px solid #ccc;
            cursor: pointer;
            box-sizing: border-box;
        }
        .top-buttons label {
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            width: 50px;
            height: 50px;
            background-color: #eee;
            border: 1px solid #ccc;
            cursor: pointer;
            box-sizing: border-box;
            margin-top: 10px;
        }
        .entry-title,
        .main-entry {
            margin-bottom: 20px;
            width: 100%;
            text-align: center;
        }
        .entry-title input {
            width: 100%;
            max-width: 400px;
            padding: 8px;
            margin-bottom: 10px;
            box-sizing: border-box;
            text-align: center;
            border: 1px solid #ccc;
            font-size: 24px;
        }
        .main-entry div {
            width: 100%;
            max-width: 800px;
            min-height: 600px;
            overflow-y: auto;
            border: 1px solid #000;
            padding: 5px;
            box-sizing: border-box;
            text-align: left;
            margin-left: auto;
            margin-right: auto;
            font-size: 16px;
        }
        #imgInput {
            display: none;
        }
        .add-image-button {
            background-color: transparent;
            border: none;
            cursor: pointer;
            font-size: 20px;
        }
        .add-image-button {
            background-color: #ddd;
        }
        .top-buttons button,
        .top-buttons label {
            filter: brightness(85%);
        }
        #font-size-controls {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        #font-size-display {
            font-size: 20px;
            width: 50px;
            text-align: center;
        }
        .font-size-control-button {
            cursor: pointer;
            padding: 5px 10px;
            border: none;
            background-color: #ddd;
            font-size: 20px;
        }
        #colorPalette {
            display: none;
            position: absolute;
            top: 50px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #fff;
            border: 1px solid #ccc;
            padding: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            margin-top: 30px;
        }
        .color-swatch {
            width: 30px;
            height: 30px;
            display: inline-block;
            margin: 5px;
            cursor: pointer;
        }
        .color-swatch.red { background-color: red; }
        .color-swatch.blue { background-color: blue; }
        .color-swatch.green { background-color: green; }
        .color-swatch.yellow { background-color: yellow; }
        .color-swatch.purple { background-color: purple; }
        .color-swatch.black { background-color: black; }
        .color-input-container {
            display: flex;
            align-items: center;
            margin-top: 10px;
        }
        .color-input-container input {
            margin-left: 10px;
            padding: 5px;
            font-size: 16px;
            width: 100px;
            text-transform: uppercase;
        }
        .apply-color-button {
            margin-left: 10px;
            padding: 5px 10px;
            cursor: pointer;
            border: none;
            background-color: #ddd;
            font-size: 16px;
        }
    </style>
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
</head>
<body>
    <div class="container">
        <div class="top-buttons">
            <button onclick="goToDashboard()" title="Atpakaļ uz paneli">←</button>
            <button onclick="addImage()">➕</button>
            <input type="file" id="image-upload" style="display: none;">
            <button onclick="undo()">↩️</button>
            <button onclick="redo()">↪️</button>
            <div id="font-size-controls">
                <input type="number" id="font-size-display" value="16" onchange="changeFontSize()">
            </div>
            <button title="Regulēt fonta krāsu" onclick="toggleColorPalette()">A</button>
            <button title="Treknrakstā" onclick="makeTextBold()">B</button>
            <button title="Slīpraksts" onclick="makeTextItalic()">I</button>
            <button title="Pasvītrot" onclick="underlineText()">U</button>
            <button title="Saglabāt" onclick="saveChanges()">💾</button>
            <button title="Nodzēst ierakstu" onclick="deleteEntry()">🗑️</button>
        </div>

        <div class="entry-title">
            <form id="entryForm" method="POST" action="{{ route('save_diary_entry') }}" enctype="multipart/form-data">
                @csrf
                <label for="title">Заголовок:</label><br>
                <input type="text" id="title" name="title" placeholder="Ievadiet virsrakstu"><br><br>
                
                <label for="content">Содержание:</label><br>
                <div id="mainDiv" contenteditable="true" style="font-size: 16px; border: 1px solid #ccc; width: 90%; height: 700px; overflow-y: auto;"></div><br><br>
                
                <label for="image">Изображение:</label><br>
                <input type="file" id="image" name="image"><br><br>
                
                <button type="button" onclick="submitForm()">Сохранить запись</button>
            </form>
        </div>

        <div id="colorPalette">
            <div class="color-swatch red" onclick="changeFontColor('red')"></div>
            <div class="color-swatch blue" onclick="changeFontColor('blue')"></div>
            <div class="color-swatch green" onclick="changeFontColor('green')"></div>
            <div class="color-swatch yellow" onclick="changeFontColor('yellow')"></div>
            <div class="color-swatch purple" onclick="changeFontColor('purple')"></div>
            <div class="color-swatch black" onclick="changeFontColor('black')"></div>

            <div class="color-input-container">
                <input type="text" id="colorInput" placeholder="HEX">
                <button class="apply-color-button" onclick="applyCustomColor()">Применить</button>
            </div>
        </div>
    </div>

    <script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
    <script>
        function submitForm() {
            // Get the content from mainDiv
            var content = document.getElementById('mainDiv').innerHTML;
            
            // Set the content as the value of a hidden input field in the form
            document.getElementById('content').value = content;
            
            // Submit the form
            document.getElementById('entryForm').submit();
        }

      var quill = new Quill('#mainDiv', {
        theme: 'snow',
        modules: {
          toolbar: false, // Disable the default toolbar
          history: {
            delay: 1500,
            maxStack: 500,
            userOnly: true
          }
        },
        placeholder: 'Kā pagāja diena?',
        clipboard: {
          matchVisual: false // Disable pasting HTML
        }
      });
      
      function addImage() {
            document.getElementById('image-upload').click();
        }

        document.getElementById('image-upload').addEventListener('change', function(event) {
            const files = event.target.files;
            if (!files || files.length === 0) return;

            const file = files[0];
            if (file.type.indexOf('image/') === 0) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const range = quill.getSelection();
                    const imageUrl = e.target.result;
                    quill.insertEmbed(range.index, 'image', imageUrl);
                };
                reader.readAsDataURL(file);
            }
        });

      function goToDashboard() {
        window.location.href = "{{ route('dashboard') }}";
      }

      function undo() {
        quill.history.undo();
      }

      function redo() {
        quill.history.redo();
      }

      function addImage(event) {
        const files = event.target.files;

        for (let i = 0; i < files.length; i++) {
          const file = files[i];
          if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
              const range = quill.getSelection();
              const imageUrl = e.target.result;
              quill.insertEmbed(range.index, 'image', imageUrl);
            };
            reader.readAsDataURL(file);
          }
        }

        event.target.value = '';
      }
      
            function changeFontSize() {
    var div = document.getElementById('mainDiv');
    var size = document.getElementById('font-size-display').value;
    if (size >= 13 && size <= 35) {
        div.style.fontSize = size + 'px';
        updateHistory();
    } else if (size < 13) {
        div.style.fontSize = '13px';
        document.getElementById('font-size-display').value = 13;
        updateHistory();
    } else {
        div.style.fontSize = '35px';
        document.getElementById('font-size-display').value = 35;
        updateHistory();
    }
}

function increaseFontSize() {
    var fontSizeDisplay = document.getElementById('font-size-display');
    var size = parseFloat(fontSizeDisplay.value) + 1;
    if (size <= 35) {
        fontSizeDisplay.value = size;
        changeFontSize();
    }
}

function decreaseFontSize() {
    var fontSizeDisplay = document.getElementById('font-size-display');
    var size = parseFloat(fontSizeDisplay.value) - 1;
    if (size >= 13) {
        fontSizeDisplay.value = size;
        changeFontSize();
    }
}
        
        

      function makeTextBold() {
        quill.format('bold', !quill.getFormat().bold);
      }

      function makeTextItalic() {
        quill.format('italic', !quill.getFormat().italic);
      }

      function underlineText() {
        quill.format('underline', !quill.getFormat().underline);
      }

      function toggleColorPalette() {
    var palette = document.getElementById('colorPalette');
    palette.style.display = (palette.style.display === 'none' || palette.style.display === '') ? 'block' : 'none';
}

      function changeFontColor(color) {
        quill.format('color', color);
      }

      function applyCustomColor() {
            const color = document.getElementById("colorInput").value;
            quill.format('color', color);
            toggleColorPalette(); // Скрыть палитру после выбора цвета
        }

      function saveChanges() {
            const title = document.getElementById("title").value;
            const content = quill.root.innerHTML;
            // Реализуйте сохранение изменений, например, отправку на сервер
            console.log('Title:', title);
            console.log('Content:', content);
        }

        // Функция для удаления записи (замените на свою реализацию)
        function deleteEntry() {
            if (confirm("Вы уверены, что хотите удалить эту запись?")) {
                quill.setContents([]); // Очищаем содержимое Quill
                document.getElementById("title").value = ""; // Очищаем поле заголовка
                saveChanges(); // Вызываем сохранение после удаления
            }
        }
    </script>
</div>
</body>
</html>