<x-app-layout>
  
    <div class="container">
        <div class="top-right">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit">Beigt darbu</button>
            </form>
        </div>

        <div class="entries">
            <div class="entry-row">
                <button onclick="createNewEntry()"><span>&#9997;</span> Izveidot jaunu ierakstu</button>
                <button onclick="viewAllEntries()"><span>&#128214;</span> Посмотреть все записи</button>
            </div>
        </div>
    </div>

    <style>
    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
    }

    body {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        background-color: #fff;
    }

    .bg-container {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -1;
        background-color: #f2f2f2;
    }

    .container {
            width: 100%;
            max-width: 800px;
            background-color: transparent;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 40px; /* Внутренний отступ контейнера */
            text-align: center;
            position: relative;
            margin: 0 auto; /* Центрирование контейнера по горизонтали */
            margin-right: 50px;
        }

        .top-right {
            position: absolute;
            top: 20px; /* Поднял кнопку выше */
            right: 20px;
        }

        .top-right button {
            background-color: #dc3545;
            color: #fff;
            border: none;
            padding: 14px 28px; /* Увеличил размер кнопки */
            border-radius: 6px;
            cursor: pointer;
            margin-bottom: 20px;
        }

        .entries {
            margin-top: 40px; /* Увеличил отступ сверху */
        }

        .entry-row {
            display: flex;
            justify-content: center;
            margin-bottom: 40px; /* Увеличил отступ между кнопками */
        }

        .entry-row button {
            background-color: #28a745;
            color: #fff;
            border: none;
            padding: 20px 40px; /* Размер кнопок создания и просмотра записей */
            border-radius: 8px;
            cursor: pointer;
            margin: 0 20px; /* Отступы между кнопками */
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px; /* Размер шрифта */
        }

        .entry-row button span {
            margin-right: 10px; /* Увеличил отступ между эмодзи и текстом */
        }
</style>

     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script>
        $(function() {
            $("#datepicker").datepicker({
                dateFormat: "yy-mm-dd"
            });
        });

        function createNewEntry() {
            console.log("Izveidojam jaunu ierakstu");
            window.location.href = "{{ route('entry_creation_page') }}";
        }

        function viewAllEntries() {
            console.log("Переходим на страницу со всеми записями пользователя");
            window.location.href = "{{ route('all_entries') }}"; 
        }
    </script>
</x-app-layout>