@extends('layouts.app')

@section('content')
    <div class="container">
        <h1>Все записи</h1>

        <!-- Форма поиска по дате -->
        <div class="search-container">
            <form method="GET" action="{{ route('search_entries') }}">
                <label for="datepicker">Выберите дату:</label>
                <input type="text" id="datepicker" name="date" placeholder="YYYY-MM-DD">
                <button type="submit">Поиск</button>
            </form>
        </div>

        <!-- Список всех записей -->
        <div class="entries">
            @foreach ($entries as $entry)
                <div class="entry">
                    <h2>{{ $entry->title }}</h2>
                    <div>{!! $entry->content !!}</div>
                    @if ($entry->image_path)
                        <img src="{{ asset('storage/' . $entry->image_path) }}" alt="Image">
                    @endif
                    <p><small>Создано: {{ $entry->created_at }}</small></p>
                </div>
            @endforeach
        </div>
    </div>

    <style>
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .search-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .search-container label {
            font-size: 18px;
            margin-right: 10px;
        }

        .search-container input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        .search-container button {
            background-color: #007bff;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }

        .entries {
            margin-top: 20px;
        }

        .entry {
            margin-bottom: 20px;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .entry h2 {
            margin-bottom: 10px;
        }

        .entry img {
            max-width: 100%;
            height: auto;
            display: block;
            margin-top: 10px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

    <script>
        $(function() {
            $("#datepicker").datepicker({
                dateFormat: "yy-mm-dd"
            });
        });
    </script>
@endsection
