<?php

namespace App\Http\Controllers;

use App\Models\Entry;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EntryController extends Controller
{
    public function searchEntries(Request $request)
    {
        $entries = Entry::where('user_id', Auth::id())
                        ->whereDate('created_at', $request->date)
                        ->get();

        return view('search_entries', ['entries' => $entries]);
    }

    public function allEntries()
    {
        // Загрузите все записи текущего пользователя из базы данных
        $entries = Entry::where('user_id', Auth::id())->get();

        return view('all_entries', ['entries' => $entries]);
    }

    public function saveDiaryEntry(Request $request)
    {
        // Validate incoming request
        $request->validate([
            'title' => 'required|string|max:80',
            'content' => 'required|string',
        ]);

        // Save the diary entry to database or any other storage mechanism
        $entry = new Entry();
        $entry->user_id = Auth::id();
        $entry->title = $request->input('title');
        $entry->content = $request->input('content');

        // Save image path if an image is uploaded
        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('entries', 'public');
            $entry->image_path = $imagePath;
        }

        $entry->save();

        return redirect()->route('dashboard')->with('success', 'Diary entry saved successfully.');
    }
}
