﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using orthodox;
using orthodox.Model;
using AutoMapper;
using orthodox.Mapping;
using orthodox.Dto;


namespace orthodox.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PersonInformationsController : ControllerBase
    {
        private readonly OrthodoxContext _context;
        private readonly IMapper _mapper;

        public PersonInformationsController(
            OrthodoxContext context,
            IMapper mapper)
        {
            _context = context;
            _mapper = mapper;
        }

        
        [HttpGet]
        public async Task<ActionResult<List<PersonInformationDto>>> GetPersonInfo()
        {
            var pinform = await _context.PersonInformations.ToListAsync();
            var pinformDto = _mapper.Map<List<PersonInformationDto>>(pinform);
            return pinformDto;
        }
        [HttpGet("{id}")]
        public async Task<ActionResult<PersonInformationDto>> GetPInfoId(int id)
        {
            var pinform = await _context.PersonInformations.FindAsync(id);
            var pinformDt = _mapper.Map<PersonInformationDto>(pinform);
            if (pinformDt == null)
            {
                return NotFound();
            }

            return pinformDt;
        }

        [HttpPost]
        public async Task<ActionResult<PersonInformationDto>> CreatePInfo(PersonInformationDto PInfoCreateDTO)
        {
            var PInform = _mapper.Map<PersonInformation>(PInfoCreateDTO);

            _context.PersonInformations.Add(PInform);
            await _context.SaveChangesAsync();

            var PInfoDTO = _mapper.Map<PersonInformationDto>(PInfoCreateDTO);

            return CreatedAtAction(nameof(GetPInfoId), new { id = PInfoDTO.Id }, PInfoDTO);
        }




        [HttpPut("{id}")]
        public async Task<IActionResult> PutPInfoExists(int id, [FromBody] PersonInformationDto PInfoExistsDTO)
        {
            var pInfoExist = await PInfoExists(id);

            if (!pInfoExist)
            {
                return BadRequest();
            }

            var pInfo = _mapper.Map<PersonInformation>(PInfoExistsDTO);
            pInfo.Id = id;
            _context.Entry(pInfo).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!pInfoExist)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        [HttpDelete("{id}")]
        public async Task<IActionResult> DeletePInfo(int id)
        {
            var PInfo = await _context.PersonInformations.FindAsync(id);
            if (PInfo == null)
            {
                return NotFound();
            }

            _context.PersonInformations.Remove(PInfo);
            await _context.SaveChangesAsync();

            return NoContent();
        }


        private async Task<bool> PInfoExists(int id)
        {
            return await _context.PersonInformations.AnyAsync(e => e.Id == id);
        }
    }
}
