﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;

namespace orthodox.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PaymentInfoController : ControllerBase
    {
        private readonly OrthodoxContext _context;

        public PaymentInfoController(OrthodoxContext context)
        {
            _context = context;
        }

        [HttpGet]
        public async Task<IActionResult> GetPaymentInfo()
        {
            using (var command = _context.Database.GetDbConnection().CreateCommand())
            {
                command.CommandText = "SELECT * FROM vw_PaymentInfo";
                await _context.Database.GetDbConnection().OpenAsync();

                using (var result = await command.ExecuteReaderAsync())
                {
                    var paymentInfos = new List<object>();

                    while (await result.ReadAsync())
                    {
                        paymentInfos.Add(new
                        {
                            Dat = result["Dat"],
                            Dontype = result["Dontype"],
                            Username = result["Username"],
                            Payment = result["payment"]
                        });
                    }

                    return Ok(paymentInfos);
                }
            }
        }
    }
}

