﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using orthodox;
using orthodox.Model;
using AutoMapper;
using orthodox.Dto;

namespace orthodox.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PakalpojumiController : ControllerBase
    {
        private readonly OrthodoxContext _context;
        private readonly IMapper _mapper;

        public PakalpojumiController(
            OrthodoxContext context,
            IMapper mapper)
        {
            _context = context;
            _mapper = mapper;
        }

        [HttpGet]
        //[HttpGet("[action]")]
        public async Task<ActionResult<List<PakalpojumiDto>>> GetPakalpojumi()
        {
            var pakalpojumi = await _context.Pakalpojumis.ToListAsync();
            var pakalpojumiDto = _mapper.Map<List<PakalpojumiDto>>(pakalpojumi);
            return pakalpojumiDto;
        }
        [HttpGet("{id}")]
        public async Task<ActionResult<PakalpojumiDto>> GetPakalpojumi(int id)
        {
            var pakalpojumi = await _context.Pakalpojumis.FindAsync(id);
            var pakalpojumiDto = _mapper.Map<PakalpojumiDto>(pakalpojumi);
            if (pakalpojumiDto == null)
            {
                return NotFound();
            }

            return pakalpojumiDto;
        }

        [HttpPost]
        public async Task<ActionResult<PakalpojumiDto>> CreatePakalpojumi(PakalpojumiDto pakalpojumiDto)
        {
            var pakalpojumi = _mapper.Map<Pakalpojumi>(pakalpojumiDto);

            _context.Pakalpojumis.Add(pakalpojumi);
            await _context.SaveChangesAsync();

            var PakalpojumiDTO = _mapper.Map<PakalpojumiDto>(pakalpojumiDto);

            return CreatedAtAction(nameof(GetPakalpojumi), new { id = PakalpojumiDTO.Id }, PakalpojumiDTO);
        }



        [HttpPut("{id}")]
        public async Task<IActionResult> PutPakalpojumiExists(int id, [FromBody] PakalpojumiDto pakalpojumiExistsDTO)
        {
            var pakalpojumiExist = await PakalpojumiExists(id);

            if (!pakalpojumiExist)
            {
                return BadRequest();
            }

            var pakalpojumi = _mapper.Map<Pakalpojumi>(pakalpojumiExistsDTO);
            pakalpojumi.Id = id;
            _context.Entry(pakalpojumi).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!pakalpojumiExist)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        [HttpDelete("{id}")]
        public async Task<IActionResult> DeletePakalpojumi(int id)
        {
            var pakalpojumi = await _context.Pakalpojumis.FindAsync(id);
            if (pakalpojumi == null)
            {
                return NotFound();
            }

            _context.Pakalpojumis.Remove(pakalpojumi);
            await _context.SaveChangesAsync();

            return NoContent();
        }
        private async Task<bool> PakalpojumiExists(int id)
        {
            return await _context.Pakalpojumis.AnyAsync(e => e.Id == id);
        }
    }
}
