﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using orthodox;
using orthodox.Model;
using AutoMapper;
using orthodox.Dto;
using System.Data;

namespace orthodox.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class KlientaInformacijasController : ControllerBase
    {
        private readonly OrthodoxContext _context;
        private readonly IMapper _mapper;

        public KlientaInformacijasController(
            OrthodoxContext context,
            IMapper mapper)
        {
            _context = context;
            _mapper = mapper;
        }

        [HttpGet]
        //[HttpGet("[action]")]
        public async Task<ActionResult<List<KlientaInformacijaDto>>> GetKInfo()
        {
            var KInfo = await _context.KlientaInformacijas.ToListAsync();
            var KInfoDto = _mapper.Map<List<KlientaInformacijaDto>>(KInfo);
            return KInfoDto;
        }
        [HttpGet("{id}")]
        public async Task<ActionResult<KlientaInformacijaDto>> KInfos(int id)
        {
            var KInfo = await _context.KlientaInformacijas.FindAsync(id);
            var KInfoDto = _mapper.Map<KlientaInformacijaDto>(KInfo);
            if (KInfoDto == null)
            {
                return NotFound();
            }

            return KInfoDto;
        }

        [HttpPost]
        public async Task<ActionResult<KlientaInformacijaDto>> CreateKInfo(KlientaInformacijaDto klientaInformacijaDto)
        {
            var KInfo = _mapper.Map<KlientaInformacija>(klientaInformacijaDto);

            _context.KlientaInformacijas.Add(KInfo);
            await _context.SaveChangesAsync();

            var KInfoDTO = _mapper.Map<KlientaInformacijaDto>(klientaInformacijaDto);

            return CreatedAtAction(nameof(KInfos), new { id = KInfoDTO.Id }, KInfoDTO);
        }



        [HttpPut("{id}")]
        public async Task<IActionResult> PutKInfoExists(int id, [FromBody] KlientaInformacijaDto KInfoDto)
        {
            var KInfoExist = await KlientaInformacijaExists(id);

            if (!KInfoExist)
            {
                return BadRequest();
            }

            var kInfo = _mapper.Map<KlientaInformacija>(KInfoDto);
            kInfo.Id = id;
            _context.Entry(kInfo).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!KInfoExist)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        [HttpDelete("{id}")]
        public async Task<IActionResult> DeleteKInfo(int id)
        {
            var kInfo = await _context.KlientaInformacijas.FindAsync(id);
            if (kInfo == null)
            {
                return NotFound();
            }

            _context.KlientaInformacijas.Remove(kInfo);
            await _context.SaveChangesAsync();

            return NoContent();
        }
        private async Task<bool> KlientaInformacijaExists(int id)
        {
            return await _context.KlientaInformacijas.AnyAsync(e => e.Id == id);
        }







        //  Donation Form
        [HttpPost("ExecuteInsertPakalpojumiInformation")]
        public async Task<IActionResult> ExecuteInsertPakalpojumiInformation([FromBody] PakalpojumiInputModel input)
        {
            if (!ModelState.IsValid)
            {
                return BadRequest(ModelState);
            }
            using (var command = _context.Database.GetDbConnection().CreateCommand())
            {
                command.CommandType = CommandType.StoredProcedure;
                command.CommandText = "InsertPakalpojumiInformation";

                var pDonationType = command.CreateParameter();
                pDonationType.ParameterName = "@Donation_type1";
                pDonationType.Value = input.DonationType;
                command.Parameters.Add(pDonationType);

                var pUsername = command.CreateParameter();
                pUsername.ParameterName = "@Username1";
                pUsername.Value = input.Username;
                command.Parameters.Add(pUsername);

                var pName = command.CreateParameter();
                pName.ParameterName = "@vards";
                pName.Value = input.Name;
                command.Parameters.Add(pName);

                var pEmail = command.CreateParameter();
                pEmail.ParameterName = "@epasts";
                pEmail.Value = input.Email;
                command.Parameters.Add(pEmail);

                var pPhone = command.CreateParameter();
                pPhone.ParameterName = "@tel";
                pPhone.Value = input.Phone;
                command.Parameters.Add(pPhone);

                await command.Connection.OpenAsync();
                await command.ExecuteNonQueryAsync();
                command.Connection.Close();
            }

            return Ok();
        }


    }
}
