﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.EntityFrameworkCore;
using orthodox;
using AutoMapper;
using orthodox.Model;
using orthodox.Mapping;

namespace orthodox.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class DataController : ControllerBase
    {
        private readonly OrthodoxContext _context;
        private readonly IMapper _mapper;

        public DataController(
            OrthodoxContext context,
            IMapper mapper)
        {
            _context = context;
            _mapper = mapper;
        }

        [HttpGet]
        //[HttpGet("[action]")]
        public async Task<ActionResult<List<DataDto>>> GetDatums()
        {
            var data = await _context.Datums.ToListAsync();
            var dataDtos = _mapper.Map<List<DataDto>>(data);
            return dataDtos;
        }
        
        [HttpGet("{id}")]
        public async Task<ActionResult<DataDto>> GetDataId(int id)
        {
            var data = await _context.Datums.FindAsync(id);
            var daraDt = _mapper.Map<DataDto>(data);
            if (daraDt == null)
            {
                return NotFound();
            }

            return daraDt;
        }

        [HttpPost]
        public async Task<ActionResult<DataDto>> CreateData(DataDto dataCreateDTO)
        {
            var datum = _mapper.Map<Datum>(dataCreateDTO);

            _context.Datums.Add(datum);
            await _context.SaveChangesAsync();

            var dataDTO = _mapper.Map<DataDto>(dataCreateDTO);

            return CreatedAtAction(nameof(GetDataId), new { id = dataDTO.Id }, dataDTO);
        }
        [HttpPut("{id}")]
        public async Task<IActionResult> PutHome(int id, [FromBody] DataDto dataUpdateDTO)
        {
            var dataExist = await DataExists(id);

            if (!dataExist)
            {
                return BadRequest();
            }

            var data = _mapper.Map<Datum>(dataUpdateDTO);
            data.Id = id;
            _context.Entry(data).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!dataExist)
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        [HttpDelete("{id}")]
        public async Task<IActionResult> DeleteData(int id)
        {
            var data = await _context.Datums.FindAsync(id);
            if (data == null)
            {
                return NotFound();
            }

            _context.Datums.Remove(data);
            await _context.SaveChangesAsync();

            return NoContent();
        }
        private async Task<bool> DataExists(int id)
        {
            return await _context.Datums.AnyAsync(e => e.Id == id);
        }
    }
}
