-- --------------------------------------------------------
-- Хост:                         127.0.0.1
-- Версия сервера:               10.4.22-MariaDB - mariadb.org binary distribution
-- Операционная система:         Win64
-- HeidiSQL Версия:              11.3.0.6295
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Дамп структуры базы данных orthodox
CREATE DATABASE IF NOT EXISTS `orthodox` /*!40100 DEFAULT CHARACTER SET utf8mb4 */;
USE `orthodox`;

-- Дамп структуры для таблица orthodox.datums
CREATE TABLE IF NOT EXISTS `datums` (
  `ID` int(8) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `Payment_date` date DEFAULT NULL COMMENT 'Sanemsanas_laiks',
  `Payment_type` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4;

-- Дамп данных таблицы orthodox.datums: ~9 rows (приблизительно)
/*!40000 ALTER TABLE `datums` DISABLE KEYS */;
/*!40000 ALTER TABLE `datums` ENABLE KEYS */;

-- Дамп структуры для представление orthodox.donation_information
-- Создание временной таблицы для обработки ошибок зависимостей представлений
CREATE TABLE `donation_information` (
	`Dat` DATE NULL COMMENT 'Sanemsanas_laiks',
	`Dontype` VARCHAR(15) NULL COMMENT 'Izveleta_pakalpojuma' COLLATE 'utf8mb4_general_ci',
	`Username` VARCHAR(15) NULL COMMENT 'Vardus_uz_lugšanos' COLLATE 'utf8mb4_general_ci',
	`payment` VARCHAR(8) NULL COMMENT 'Klienta_vards' COLLATE 'utf8mb4_general_ci'
) ENGINE=MyISAM;

-- Дамп структуры для таблица orthodox.klienta_informacija
CREATE TABLE IF NOT EXISTS `klienta_informacija` (
  `ID` int(8) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ID_Transaction_date` int(11) DEFAULT NULL COMMENT 'ID_datums',
  `ID_DT` int(11) DEFAULT NULL COMMENT 'ID_Izveleta_pakalpojuma',
  `ID_person` int(11) DEFAULT NULL COMMENT 'Klienta_e-pasts',
  `payment` varchar(8) DEFAULT NULL COMMENT 'Klienta_vards',
  PRIMARY KEY (`ID`),
  KEY `ID_DT` (`ID_DT`),
  KEY `ID_person` (`ID_person`),
  KEY `Datee` (`ID_Transaction_date`) USING BTREE,
  CONSTRAINT `FK_klienta_inofrmacfija_datums` FOREIGN KEY (`ID_Transaction_date`) REFERENCES `datums` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_klienta_inofrmacfija_pakalpojumi` FOREIGN KEY (`ID_DT`) REFERENCES `pakalpojumi` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_klienta_inofrmacfija_personigas_info` FOREIGN KEY (`ID_person`) REFERENCES `person_information` (`ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4;

-- Дамп данных таблицы orthodox.klienta_informacija: ~9 rows (приблизительно)
/*!40000 ALTER TABLE `klienta_informacija` DISABLE KEYS */;
/*!40000 ALTER TABLE `klienta_informacija` ENABLE KEYS */;

-- Дамп структуры для таблица orthodox.pakalpojumi
CREATE TABLE IF NOT EXISTS `pakalpojumi` (
  `ID` int(8) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `Donation_type` varchar(15) DEFAULT NULL COMMENT 'Izveleta_pakalpojuma',
  `Username` varchar(15) DEFAULT NULL COMMENT 'Vardus_uz_lugšanos',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4;

-- Дамп данных таблицы orthodox.pakalpojumi: ~9 rows (приблизительно)
/*!40000 ALTER TABLE `pakalpojumi` DISABLE KEYS */;
/*!40000 ALTER TABLE `pakalpojumi` ENABLE KEYS */;

-- Дамп структуры для таблица orthodox.person_information
CREATE TABLE IF NOT EXISTS `person_information` (
  `ID` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `Name` varchar(11) DEFAULT NULL,
  `Phone` varchar(10) DEFAULT NULL COMMENT 'Telefona_numurs',
  `Email` varchar(20) DEFAULT NULL COMMENT 'E-pasts',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4;

-- Дамп данных таблицы orthodox.person_information: ~9 rows (приблизительно)
/*!40000 ALTER TABLE `person_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `person_information` ENABLE KEYS */;

-- Дамп структуры для процедура orthodox.TEST1
DELIMITER //
CREATE PROCEDURE `TEST1`(
	IN `Donation_type1` VARCHAR(50),
	IN `Username1` VARCHAR(50),
	IN `payment` VARCHAR(50),
	IN `vards` VARCHAR(50),
	IN `epasts` VARCHAR(50),
	IN `tel` VARCHAR(50)
)
BEGIN
insert into pakalpojumi (Donation_type,Username) values(Donation_type1,Username1);
select max(id) into @ID_dt from pakalpojumi;
#select last_insert_id() into @ID_dt;
insert into datums (Payment_date,Payment_type) values(date(now()),"paypal");
select max(id) into @ID_Transaction_date from datums;
#select last_insert_id() into @ID_Transaction_date;
insert into person_information (Name,Email,Phone) values(vards,epasts,tel);
select max(id) into @ID_person from person_information;
#select last_insert_id() into @ID_person;
insert into klienta_informacija (ID_Transaction_date,ID_DT,ID_person,payment) values(@ID_Transaction_date,@ID_dt,@ID_person,"paypal");
END//
DELIMITER ;

-- Дамп структуры для представление orthodox.donation_information
-- Удаление временной таблицы и создание окончательной структуры представления
DROP TABLE IF EXISTS `donation_information`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `donation_information` AS SELECT d.Payment_date AS Dat, pak.Donation_type AS Dontype, pak.Username AS Username, kinf.payment AS payment
 FROM datums AS d, pakalpojumi AS pak, klienta_informacija AS kinf
 WHERE kinf.ID_Transaction_date = d.ID AND kinf.ID_DT = pak.ID AND kinf.ID_person=pak.ID 
 ORDER BY `Dat` DESC ;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
