<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bundle\SecurityBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Cleans up the remember me verifier cache if cache is missing.
 *
 * @author Jordi Boggiano <j.boggiano@seld.be>
 */
class CleanRememberMeVerifierPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container)
    {
        if (!$container->hasDefinition('cache.system')) {
            $container->removeDefinition('cache.security_token_verifier');
        }
    }
}
