<?php

declare(strict_types=1);

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\BlockBundle\Cache;

use Sonata\BlockBundle\Block\BlockContextInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ResponseEvent;

/**
 * @deprecated since sonata-project/block-bundle 4.11 and will be removed in 5.0.
 */
interface HttpCacheHandlerInterface
{
    /**
     * Add valid http cache information.
     *
     * The Response object is the final object returned to the client
     */
    public function alterResponse(Response $response): void;

    /**
     * This function can update a state to store the final ttl used for the page
     * The response object point to the Response generated by a block service and
     * not the final response rendered to the client.
     */
    public function updateMetadata(Response $response, ?BlockContextInterface $blockContext = null): void;

    public function onKernelResponse(ResponseEvent $event): void;
}
