<?php

declare(strict_types=1);

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\AdminBundle\Action;

use Sonata\AdminBundle\Admin\Pool;
use Sonata\AdminBundle\Templating\TemplateRegistryInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Twig\Environment;

final class SearchAction
{
    private Pool $pool;

    private TemplateRegistryInterface $templateRegistry;

    private Environment $twig;

    public function __construct(
        Pool $pool,
        TemplateRegistryInterface $templateRegistry,
        Environment $twig
    ) {
        $this->pool = $pool;
        $this->templateRegistry = $templateRegistry;
        $this->twig = $twig;
    }

    public function __invoke(Request $request): Response
    {
        return new Response($this->twig->render($this->templateRegistry->getTemplate('search'), [
            'base_template' => $request->isXmlHttpRequest() ?
                $this->templateRegistry->getTemplate('ajax') :
                $this->templateRegistry->getTemplate('layout'),
            'query' => $request->get('q'),
            'groups' => $this->pool->getDashboardGroups(),
        ]));
    }
}
