<?php

namespace App\Controller;

use App\Entity\Product;
use App\Repository\CategoryRepository;
use App\Repository\ProductRepository;
use App\Repository\ReviewRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class IceCreamController extends AbstractController
{
    #[Route('/')]
    public function all(Request $request, ProductRepository $productRepository, CategoryRepository $categoryRepository)
    {
        $category = $request->query->get('category');
   
        if ($category) {
            $products = $productRepository->findByCategory($category);
        } else {
            $products = $productRepository->findAll();
        }
 
        $categories = $categoryRepository->findAll();
        return $this->render('ice_cream/all.html.twig', [
          'products' => $products,
          'categories' => $categories,
          'selected_category' => $category
        ]);
    }

    #[Route('product/{id}')]
    public function get(int $id, ProductRepository $productRepository)
    {
        $product = $productRepository->find($id);
        return $this->render('ice_cream/get.html.twig', [
          'product' => $product
        ]);
    }

    #[Route('cart')]
    public function cart(Request $request, ProductRepository $productRepository)
    {
        $id = $request->cookies->get('cart_id');
        $products = $productRepository->findByCart($id);

        $sum = 0.00;
  
        /** @var Product $product */
        foreach ($products as $product) {
            $sum += $product->getPrice();
        }
        //dd($products);
        return $this->render('ice_cream/cart.html.twig', [
          'products' => $products,
          'price_sum' => $sum
        ]);
    }

    #[Route('contacts')]
    public function contacts()
    {
        return $this->render('ice_cream/contacts.html.twig');
    }

    #[Route('reviews')]
    public function reviews(ReviewRepository $reviewRepository)
    {
        $reviews = $reviewRepository->findAll();

        return $this->render('ice_cream/reviews.html.twig', [
            'reviews' => $reviews
        ]);
    }
}
