<?php

namespace App\Controller;

use App\Entity\Cart;
use App\Entity\Review;
use App\Repository\CartRepository;
use App\Repository\CategoryRepository;
use App\Repository\ProductRepository;
use App\Repository\ReviewRepository;
use JMS\Serializer\SerializerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class DataController extends AbstractController
{
    #[Route('createNewCart')]
    public function createCart(CartRepository $cartRepository)
    {
      $cart = new Cart();
      $cart->setName('Test');
      $cart->setPhone('Kekv');
      $cartRepository->save($cart, true);

      return new JsonResponse([
        'id' => $cart->getId(),
      ]);
    }

    #[Route('addProductToCart')]
    public function add(Request $request, ProductRepository $productRepository, CartRepository $cartRepository)
    {
      $parameters = json_decode($request->getContent(), true);
      //dd($parameters);
      $cart = $cartRepository->find($parameters['cart_id']);
      $product = $productRepository->find($parameters['product_id']);
      //dd($cart);
      $cart->addProduct($product);

      $cartRepository->save($cart, true);

      return new JsonResponse([
        'result' => 'success'
      ]);
    }

    #[Route('getC')]
    public function contacts()
    {
        return $this->render('ice_cream/contacts.html.twig');
    }
  
    #[Route('createReview')]
    public function createReview(Request $request, ReviewRepository $reviewRepository)
    {
      $parameters = json_decode($request->getContent(), true);
      //dd($parameters);
      $review = new Review();
      $review->setName($parameters['name']);
      $review->setEmail($parameters['email']);
      $review->setText($parameters['text']);
      $review->setRating($parameters['rating']);
      $reviewRepository->save($review, true);

      return new JsonResponse($review);
    }
}
