import { Component } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { AuthService } from 'src/app/auth.service';
import { RegisterUser } from 'src/app/models/register-user.model';

@Component({
  selector: 'app-register',
  templateUrl: './register.component.html',
  styleUrls: ['./register.component.scss']
})
export class RegisterComponent {

  readonly profileForm = new FormGroup({
    email: new FormControl('', { validators: [Validators.required], nonNullable: true }),
    password: new FormControl('', { validators: [Validators.required], nonNullable: true }),
  });

  constructor(private readonly userService: AuthService,
    private readonly router: Router) { }

  register() {
    this.userService.register(this.profileForm.value as RegisterUser).subscribe({
      next: res => {
      },
      error: error => {
        alert(error);
        console.log({ err: error })
      }
    });
  }
}
