import { Component } from '@angular/core';
import { AuthService } from '../auth.service';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss']
})
export class HeaderComponent {

  get isAuthenticated() {
    return this.authService.isAuth;
  }

  readonly signInRoute = 'login';

  constructor(private readonly authService: AuthService) { }

  signOut() {
    return this.authService.logout();
  }
}
