import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { LoginComponent } from './pages/login/login.component';
import { RegisterComponent } from './pages/register/register.component';
import { RestaurantAddComponent } from './pages/restaurant-add/restaurant-add.component';
import { RestaurantInfoComponent } from './pages/restaurant-info/restaurant-info.component';
import { RestaurantListComponent } from './pages/restaurant-list/restaurant-list.component';

const routes: Routes = [
  {
    path: '',
    redirectTo: 'restaurants'
  },
  {
    path: 'login',
    component: LoginComponent
  },
  {
    path: 'register',
    component: RegisterComponent
  },
  {
    path: 'restaurants',
    component: RestaurantListComponent
  },
  {
    path: 'info',
    component: RestaurantInfoComponent
  },
  {
    path: 'add-restaurant',
    component: RestaurantAddComponent
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
