<?php
$sql="
SELECT
    t.id,
    t.name,
    t.date_of_publishing,
    s.status,
    TRIM(GROUP_CONCAT(DISTINCT ' ',g.genre)) AS genre,
    TRIM(GROUP_CONCAT(DISTINCT ' ',a.author)) AS author,
    d.description,
    i.name AS src,
    i.score
FROM
title t
    LEFT JOIN 
        status s
        ON t.status_id=s.id
    LEFT JOIN 
        description d
        ON t.description_id=d.id
    LEFT JOIN
        image i
        ON t.id=i.manga_id
    LEFT JOIN 
        title_author ta
        ON t.author_id=ta.title_id
    LEFT JOIN 
        author a
        ON a.id=ta.author_id
    LEFT JOIN 
        title_genre tg
        ON t.genre_id=tg.title_id
    LEFT JOIN 
        genre g
        ON g.id=tg.genre_id
GROUP BY 
t.id
order BY 
t.id";