<?php

use App\Http\Controllers\DatiController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();
Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::middleware(['auth'])->group(function() {
    Route::get('/datis', [DatiController::class, 'index'])->name('datis_index');
    Route::get('/ajax/dati', [DatiController::class, 'ajaxDati'])->name('ajax_dati');
    Route::post('/ajax/dati/post/{id?}', [DatiController::class, 'ajaxPost'])->name('ajax_dati_post');
    Route::post('/ajax/dati/destroy/{id}', [DatiController::class, 'ajaxDestroy'])->name('ajax_dati_destroy');
});
