
$(document).ready (function () {
    $('#datiTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "/ajax/dati",
        language: {
            url:"https://cdn.datatables.net/plug-ins/1.10.19/i18n/Latvian.json"
        },
        columns: [
            {data: 'name', name:'name'},
            {data: 'surname', name:'surname'},
            {data: 'custom_data', name:'custom_data'},
            {
                data: null,
                className: "center",
                defaultContent: ''
            }
        ],
        columnDefs: [
            {
                target: -1,
                title: 'Darbības',
                orderable: false,
                render: function (data, type, row) {
                    return '<div class="dropdown">' +
                        '<a href="#" class="btn btn-clean btn-icon btn-sm btn-icon-md" data-bs-toggle="dropdown">' +
                        '<i class="fa fa-ellipsis-h"></i>' +
                        '</a>' +
                        '<ul class="dropdown-menu">' +
                        '<li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#DatiModal" data-id="' + data.id + '" data-name="' + data.name + '" data-surname="' + data.surname + '">Edit</a></li>' +
                        '<li><a class="dropdown-item dati-delete" href="#" data-id="' + data.id + '" >Delete</a></li>' +
                        '</ul>' +
                        '</div>';


                }
            }
        ]
    })

    $(document).on('click', '.dati-delete', function(e){
        if (confirm("Izdzēst ierakstu?") === true) {
            $.ajaxSetup({
                headers:{
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            })

            $.post("/ajax/dati/destroy/" + $(this).data('id'))
                .done(function(data) {
                    if (data.success) {
                        $('#datiTable').DataTable().ajax.reload()
                    } else {
                        alert(data.message)
                    }
                })
        }
    })

    $('#DatiModal-saveBtn').on('click', function (e) {
        let data = {
            id: $('#current_dati_id').val(),
            name: $('#name').val(),
            surname: $('#surname').val()
        }
            console.log(data);
        $.ajaxSetup({
            headers:{
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')        /*  ajax sagatavosana ar laravel post ajax requests */

            }
        })

        $.post("/ajax/dati/post", data)                  /*  back-end post pieprasijums ir veiksmigs */
            .done(function(data) {
                if (data.success) {
                    $('#datiTable').DataTable().ajax.reload()               /*  visi dati ko sanemam no beckend */
                    $('#DatiModal').modal('hide')
                } else {
                    alert(data.message)
                }
            })
    })

    $('#DatiModal').on('show.bs.modal', function (e) {
            let id = $(e.relatedTarget).data('id')
            let name = $(e.relatedTarget).data('name')
            let surname = $(e.relatedTarget).data('surname')


        $('#current_dati_id').val(id)
        $('#name').val(name)
        $('#surname').val(surname)
     })

    $('#DatiModal').on('hidden.bs.modal', function (e) {
        $('#current_dati_id').val('')
        $('#name').val('')
        $('#surname').val('')

    })
})




