<!doctype html>
<html lang="LV">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}"> {{-- tokens --}}
    <title>DATI</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1aFkw7cmDA6j6gD" crossorigin="anonymous">
</head>
<body>


<div class="container">
            <div class="row mb-3 mt-3"> {{-- Bootsrap klases margin bot/top --}}
                    <div class="col-6">  {{--kolona no 1-12 --}}
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#DatiModal"> {{-- Modalais logs ko izsauc ar pogu --}}
                            Pievienot vārdu
                        </button>
                    </div>
            </div>
            <div class="row">
                <table id="datiTable" class="table">
                    <thead>
                    <tr>
                        <th scope="col">Vārds</th>
                        <th scope="col">Uzvārds</th>
                        <th scope="col">Darbības</th>

                    </tr>
                    </thead>
                    <tbody>
                    @if(isset($Datis))
                        @foreach($Datis as $Dati)
                            <tr>
                                <td>{{ $Dati->name }}</td>
                                <td>{{ $Dati->surname }}</td>
                                <td><a href="#" data-bs-toggle="modal" data-bs-target="#DatiModal" data-id="{{$Dati->id}}" data-name="{{$Dati->name}}" data-surname="{{$Dati->surname}}">Edit</a> {{-- atver modalo logu ar konkrētiem datiem --}}
                                    <a class="dati-delete" href="#" data-id="{{$Dati->id}}" >Delete</a></td>

                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
<!-- Modal -->
<div class="modal fade" id="DatiModal" tabindex="-1" aria-labelledby="DatiModalLabel" aria-hidden="true"> {{-- input lauki --}}
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="DatiModalLabel">Jauns</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>

                        <input type="hidden" name="current_dati_id" id="current_dati_id" value="">
                        <div class="mb-3">
                            <label for="name" class="form-label">Vārds</label>
                            <input type="text" class="form-control"name="name" id="name" aria-describedby="name">
                        </div>
                        <div class="mb-3">
                            <label for="surname" class="form-label">Uzvārds</label>
                            <input type="text" class="form-control" name="surname" id="surname">
                        </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Aizvērt</button>
                <button id="DatiModal-saveBtn" type="button" class="btn btn-primary">Saglabāt</button> {{-- Saglabājot ajax pose kas aizsūta datus uz servera --}}
            </div>
        </div>
    </div>
</div>



<script src="https://code.jquery.com/jquery-3.6.3.min.js" integrity="sha256-pvPw+upLPUjgMXY0G+8O0xUf+/Im1MZjXxxgOcBQBXU=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js" integrity="sha384-w76AqPfDkMBDXo30jS1Sgez6pr3x5MlQ1ZAGC+nuZB+EYdgRZgiwxhTBTkF7CXvN" crossorigin="anonymous"></script>
    <script src="{{ asset('js/script.js?ver='.mt_rand(1, 100000000) / 100000000) }}"></script>
</body>
</html>

