function updateTable(data) {
    let container = $('#datiTable tbody')
    let html = ''

    $.each(data, function (key, dati) {
        html+= '<tr>'
        html+= '<td>'+dati.name+'</td>'
        html+= '<td>'+dati.surname+'</td>'
        html+= '<td><a href="#" data-bs-toggle="modal" data-bs-target="#DatiModal" data-id="'+dati.id+'" data-name="'+dati.name+'"' +
            ' data-surname="'+dati.surname+'">Edit</a> <a class="dati-delete" href="#" data-id="'+dati.id+'" >Delete</a></td>'
        html+= '</tr>'
    })

    container.empty().append(html)
}

$(document).ready (function () {
    $(document).on('click', '.dati-delete', function(e){
        if (confirm("Izdzēst ierakstu?") === true) {
            $.ajaxSetup({
                headers:{
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            })

            $.post("/ajax/dati/destroy/" + $(this).data('id'))
                .done(function(data) {
                    if (data.success) {
                        updateTable(data.datis)
                    } else {
                        alert(data.message)
                    }
                })
        }
    })

    $('#DatiModal-saveBtn').on('click', function (e) {
        let data = {
            id: $('#current_dati_id').val(),
            name: $('#name').val(),
            surname: $('#surname').val()
        }
            console.log(data);
        $.ajaxSetup({
            headers:{
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')        /*  ajax sagatavosana ar laravel post ajax requests */

            }
        })

        $.post("/ajax/dati/post", data)                  /*  back-end post pieprasijums ir veiksmigs */
            .done(function(data) {
                if (data.success) {
                    updateTable(data.datis)                   /*  visi dati ko sanemam no beckend */
                    $('#DatiModal').modal('hide')
                } else {
                    alert(data.message)
                }
            })
    })

    $('#DatiModal').on('show.bs.modal', function (e) {
            let id = $(e.relatedTarget).data('id')
            let name = $(e.relatedTarget).data('name')
            let surname = $(e.relatedTarget).data('surname')


        $('#current_dati_id').val(id)
        $('#name').val(name)
        $('#surname').val(surname)
     })

    $('#DatiModal').on('hidden.bs.modal', function (e) {
        $('#current_dati_id').val('')
        $('#name').val('')
        $('#surname').val('')

    })
})
