<?php

namespace App\Http\Controllers;

use App\Models\dati;
use Illuminate\Http\Request;

class DatiController extends Controller
{
    public function index(Request $request) {
        $Datis = Dati::all();

        return view('welcome',['Datis'=> $Datis]);
    }

    public function ajaxPost(Request $request) {

        $updating = $request->id !== null;
        $success = true;
        $message = "";

        if (!$updating) {
            $Dati = new Dati();
            $Dati->create($request->all());
        } else {
            $Dati = Dati::find($request->id);
            $Dati->update($request->all());
            $Dati->save();
        }

        return [
            'success' => $success,
            'message' => $message,
            'datis' => Dati::all()
        ];
    }
    public function ajaxDestroy(Request $request) {
        $success = true;
        $message = "";

        $Dati = Dati::find($request->id);
        $Dati->delete();

        return [
            'success' =>$success,
            'message' =>$message,
            'datis' => Dati::all()

        ];
    }


    public function post(Request $request) {
        $updating = $request->has('current_dati_id');

        if (!$updating) {
            $Dati = new Dati();
            $Dati->create($request->all());
        } else {
            $Dati = Dati::find($request->current_dati_id);
            $Dati->update($request->all());
            $Dati->save();
        }

        return redirect()->route('datis_index');

    }

    public function edit(Request $request) {
        $Datis = Dati::all();
        $current_dati = Dati::find($request->id);

        return view('welcome',['Datis'=> $Datis, 'current_dati' => $current_dati]);
    }
    public function destroy(Request $request) {
        $Dati = Dati::find($request->id);
        $Dati->delete();

        return redirect()->route('datis_index');
    }
}
