<!DOCTYPE html>
<html lang="ru">
<head>
    <!-- encoding -->
    <meta charset="UTF-8" />
    <!-- Mobile support -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!-- Majaslapas nosaukums -->
    <title>Sneakershop.lv</title>
    <meta name="description" content="Описание страницы" />
    <meta name="keywords" content="ключевые слова, фразы" />

    <!-- Styles -->
    <link rel="stylesheet" href="./css/reset.css" />
    <link rel="stylesheet" href="./css/base.css" />
    <link rel="stylesheet" href="./css/main.css" />

    <!-- Web fonts -->
    <link rel="stylesheet" href="./css/fonts/sofia-pro/stylesheet.css" />
    <link rel="stylesheet" href="./css/fonts/circular/stylesheet.css" />

    <!-- Open Graph -->
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Туристическое агентство Форест Тревел" />
    <meta property="og:description" content="Турпоходы по дикой природе" />
    <meta property="og:image" content="./img/opengraph.jpg" />

    <!-- Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="./img" />
    <link rel="icon" type="image/png" sizes="32x32" href="./img" />
    <link rel="icon" type="image/png" sizes="16x16" href="./img" />
    <link rel="manifest" href="./img" />
    <link rel="mask-icon" href="./img" color="#1a60cf" />
    <link rel="shortcut icon" href="./img" />
    <meta name="msapplication-TileColor" content="#00aba9" />
    <meta name="msapplication-config" content="./img" />
    <meta name="theme-color" content="#ffffff" />
</head>
<body>
<div class="sidebar">
    <div class="sidebar-logo">
        <div class="logo">
            <a href="index.html">
                <img src="./img/logo.png" alt="Sneakershop"></a>
        </div>
    </div>

    <nav class="sidebar-nav nav">
        <h2 class="nav-title">Catalog</h2>
        <ul class="nav-list">
            <li>
                <a href="nike.html"
                ><img src="./img/nav-icons/nike.jpg" alt="Nike" />Nike</a>
            </li>
            <li>
                <a href="adidas.html"
                ><img src="./img/nav-icons/adidas.jpg" alt="Adidas" />Adidas</a
                >
            </li>
            <li>
                <a href="jordan.html"><img src="./img/nav-icons/jordan.png" alt="Jordan" />Jordan</a>
            </li>
            <li>
                <a href="newbalance.html"
                ><img src="./img/nav-icons/newbalance.png" alt="NewBalance" />NewBalance</a
                >
            </li>
            <li>
                <a href="asics.html"
                ><img
                        src="./img/nav-icons/asics.png" alt="Asics"  />Asics</a
                >
            </li>
            <li>
                <a href="puma.html"
                ><img src="./img/nav-icons/puma.png" alt="Puma" />Puma</a
                >
            </li>
            <li>
                <a href="vans.html"
                ><img src="./img/nav-icons/vans.jpg" alt="Vans" />Vans</a
                >
            </li>
        </ul>
    </nav>

    <div class="sidebar-help">
        <a class="help" href="#">
            <img class="help-icon" src="./img/icons/help.svg" alt="" />
            Help Center
        </a>
    </div>
</div>

<main class="main">
    <header class="header">

        <!-- meklešanas lauks -->
        <div class="header-search">
            <form class="search">
                <label class="search-label">
                    <img class="search-icon" src="./img/icons/search.svg" alt="Search" />
                    <input class="search-input" type="text" placeholder="Search store" />
                </label>
            </form>
        </div>
        <!-- // meklešanas lauks  -->

        <!-- header-links -->
        <div class="header-links">
            <nav class="nav-header">
                <ul class="nav-header-list">
                    <li class="nav-header-link-text active"><a href="#">News</a></li>
                    <li class="nav-header-link-text"><a href="#">Contact us</a></li>
                    <li class="nav-header-link-text"><a href="#">About us</a></li>
                    <li class="nav-header-link-icon">
                        <a href="#"><img src="./img/icons/basket.svg" alt="Cart" /></a>
                    </li>
                    <li class="nav-header-link-icon">
                        <a href="#"><img src="./img/icons/person.svg" alt="Cart" /></a>
                    </li>
                </ul>
            </nav>
        </div>
        <!-- // header-links -->

    </header>
	<div class="cards-wrapper">
        <!-- row -->
        <div class="cards-wrapper-row">
            <!-- col -->
<?php
$data=[];
$row=array("id"=>"35", "img"=>"./img/adidas/adidassamba.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"39", "img"=>"./img/adidas/adidasozw.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"49", "img"=>"./img/adidas/adidasnmd_r1tr.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"79", "img"=>"./img/adidas/adidasnmd.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"45", "img"=>"./img/adidas/adidasniteball.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"5", "img"=>"./img/adidas/adidasadiform.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"6", "img"=>"./img/adidas/adidas5k.jpg", "alt"=>"Product");
$data[]=$row;
$row=array("id"=>"8", "img"=>"./img/adidas/adidasadi2000.jpg", "alt"=>"Product");
$data[]=$row;
//print_r($data);
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "mihails_akelans";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);
// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$sql = "SELECT
 p.NAME AS alt,
 p.photo AS img,
 p.id
 from
 prece p
 WHERE p.id_catalogs=0";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
  // output data of each row
  $i=1;
  while($row = $result->fetch_assoc()) {

?>

            <div class="card card-vertical card-product">
                <button class="card-product-fav-btn">

                    <svg width="15" height="14" viewBox="0 0 15 14" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.85293 2.23726L8.42959 1.64303C9.74052 0.290397 11.8283 0.101266 13.2084 1.27703C14.824 2.65601 14.9109 5.13801 13.4608 6.63449L7.79659 12.4831C7.62714 12.658 7.35815 12.658 7.18871 12.4831L1.5246 6.63459C0.0772874 5.1381 0.164165 2.65614 1.77968 1.27715C3.15989 0.101085 5.25089 0.291 6.55863 1.64303L7.13529 2.23726L7.49411 2.607L7.85293 2.23726Z"/>
                    </svg>

                </button>
                <a class="card-product-link" href="#?id=<?php echo $row["id"]?> ">
                    <img class="card-product-img" src="<?php echo $row["img"]?> " alt="<?php echo $row["alt"]?> ">
                </a>
            </div>


<?php

if ($i%4==0){

	?>
            </div>
            <!-- // col -->
            <!-- col -->
            <div class="cards-wrapper-col col-horizontal">
			<?php
}
	$i=$i+1;
			}
}
			?>
			            </div>
            <!-- // col -->
        </div>
        <!-- // row -->
</main>
</body>
</html>
