#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QClipboard>
#include <QDesktopServices>
#include <QUrl>
#include <QMessageBox>
#include <QInputDialog>
#include <QDrag>
#include <QMouseEvent>
#include <QMimeData>
#include <QTableWidget>

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();
    bool calculate_v; // Used to temporarily turn off saving settings to avoid infinite loops after field modifications
    bool init_stage; // Used to tell the application if its in the initialization stage
    QPoint dragStartPosition;

private slots:
    void calculate();

    void new_profile(QString profile_name);

    void SaveSettings();

    void LoadSettings();

    void on_TotCap_in_textEdited();

    void on_Crncy_in_currentIndexChanged();

    void on_RiskPerc_in_textEdited();

    void on_FeeType_in_currentIndexChanged();

    void on_EntryP_in_textEdited();

    void on_StopP_in_textEdited();

    void on_TargP_in_textChanged();

    void on_TFee_in_textEdited();

    void on_MFee_in_textEdited();

    void on_risktypebox_currentIndexChanged();

    void on_PosSize_copy_clicked();

    void on_Units_copy_clicked();

    void on_EntryP_copy_clicked();

    void on_StopP_copy_clicked();

    void on_CFee_in_textEdited();

    void on_pushButton_clicked();

    void on_RRWidget_itemChanged();

    void on_options_rrsh_1_stateChanged();

    void on_options_g_rsh_stateChanged();

    void on_options_g_rsh_ch_currentIndexChanged();

    void on_pushButton_2_clicked();

    void on_profile_selector_currentIndexChanged();

    void on_delete_button_clicked();

    void on_new_button_clicked();

    void on_rename_button_clicked();

    void on_options_g_mwsot_stateChanged();

    void on_options_g_rrinfees_stateChanged();

    int countDecimals(std::string a);

    void on_rrs_copytable_btn_clicked();

    void on_AccType_in_currentIndexChanged();

    void on_TickSize_in_textEdited(const QString &arg1);

    void on_TickValue_in_textChanged(const QString &arg1);

private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
