#include "mainwindow.h"

#include <QApplication>
#include <qtsingleapplication/src/QtSingleApplication>
class Window : public MainWindow
{
    Q_OBJECT
public:
    Window(MainWindow *parent = 0) : MainWindow(parent) {}

public slots:
    void readMessage(const QString &) { showNormal(); }
};

int main(int argc, char *argv[])
{
    QCoreApplication::setOrganizationName("Mobius");
    QCoreApplication::setOrganizationDomain("kazonomics.com");
    QCoreApplication::setApplicationName("Mobius Risk Calculator");

    QtSingleApplication a(argc, argv);
    Window *window = new Window;
    window->setAttribute(Qt::WA_QuitOnClose);
    window->setAttribute(Qt::WA_DeleteOnClose);

    QObject::connect(&a, SIGNAL(messageReceived(const QString &)), window, SLOT(readMessage(const QString &)));
    if (a.sendMessage(""))
            return 0;
    window->show();
    return a.exec();
}
#include "main.moc"
