void dragEnterEvent(QDragEnterEvent * evt) {
  QByteArray oldbyteData = evt -> encodedData("application/x-qabstractitemmodeldatalist");

  QDataStream stream( & oldbyteData, QIODevice::ReadOnly);

  kfSelection.clear();

  while (!stream.atEnd()) {
    IndexKf kf;
    QMap < int, QVariant > v;
    stream >> kf.layer >> kf.frame >> v;

    kfSelection.push_back(kf);
  }

  if (kfSelection.size() == 0)
    return;

  dragStartPosition = indexAt(evt -> pos());

  QTableWidget::dragEnterEvent(evt);
}

void dragMoveEvent(QDragMoveEvent * evt) {
  QTableWidget::dragMoveEvent(evt);
}

void dropEvent(QDropEvent * evt) {
  QModelIndex newIdx = indexAt(evt -> pos());

  int newframe, oldframe, layer;

  for (std::vector < IndexKf > ::iterator it = kfSelection.begin(); it != kfSelection.end(); ++it) {
    ( * it).item = takeItem(( * it).layer, ( * it).frame);
  }

  for (std::vector < IndexKf > ::iterator it = kfSelection.begin(); it != kfSelection.end(); ++it) {
    IndexKf kf = * it;
    layer = kf.layer;
    oldframe = kf.frame;
    newframe = newIdx.column() - dragStartPosition.column() + oldframe;

    setItem(layer, newframe, kf.item);
  }
  evt -> setDropAction(Qt::IgnoreAction);
}
@