function setCookie(cname, cvalue, exdays) {
  const d = new Date();
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
  let expires = "expires="+d.toUTCString();
  document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
  let name = cname + "=";
  let ca = document.cookie.split(';');
  for(let i = 0; i < ca.length; i++) {
    let c = ca[i];
    while (c.charAt(0) == ' ') {
      c = c.substring(1);
    }
    if (c.indexOf(name) == 0) {
      return c.substring(name.length, c.length);
    }
  }
  return "";
}

function checkCookie() {
  let user = getCookie("username");
  if (user != "") {
    alert("Welcome again " + user);
  } else {
    user = prompt("Please enter your name:", "");
    if (user != "" && user != null) {
      setCookie("username", user, 365);
    }
  }
} 
function openModal(date) {
  clicked = date;

  const eventForDay = events.find(e => e.date === clicked);

  if (eventForDay) {
    document.getElementById('eventText').innerText = eventForDay.title;
    document.getElementById('deleteEventModal').style.display = 'block';
  } else {
	document.getElementById('newEventModal').style.display = 'block';
  }

document.getElementById('modalBackDrop').style.display = 'block';
}

function load() {
document.getElementById("user").innerHTML=getCookie("user");
const weekdays = ['pirmdiena', 'otrdiena', 'trešdiena', 'ceturtdiena', 'piektdiena', 'sestdiena','svētdiena' ];
let fLen = weekdays.length;
document.getElementById("weekdays").innerHTML="";
for (let i = 0; i < weekdays.length; i++) {
	let div = document.createElement("div");
div.innerHTML=weekdays[i].replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase()});
document.getElementById("weekdays").appendChild(div);
}
const dt = new Date();
  if (nav !== 0) {
    dt.setMonth(new Date().getMonth() + (document.getElementById('nav').value*1));
  }

  const day = dt.getDate();
  const month = dt.getMonth();
  const year = dt.getFullYear();

  const firstDayOfMonth = new Date(year, month, 1);
  const daysInMonth = new Date(year, month + 1, 0).getDate();
  
  const dateString = firstDayOfMonth.toLocaleDateString('lv-LV', {
    weekday: 'long',
    year: 'numeric',
    month: 'numeric',
    day: 'numeric',
  });
  const paddingDays = weekdays.indexOf(dateString.split(', ')[0])-1;
  document.getElementById('monthDisplay').innerText = `${dt.toLocaleDateString('lv-LV', { month: 'long' }).replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase()})} ${year}`;

document.getElementById('calendar').innerHTML = '';

  for(let i = 0; i <= paddingDays + daysInMonth; i++) {
    const daySquare = document.createElement('div');
    daySquare.classList.add('day');

    const dayString = `${month + 1}/${i - paddingDays}/${year}`;

    if (i > paddingDays) {
      daySquare.innerText = i - paddingDays;
      const eventForDay = events.find(e => e.date === dayString);

      if (i - paddingDays === day && document.getElementById('nav').value*1 === 0) {
        daySquare.id = 'currentDay';
      }

      if (eventForDay) {
        const eventDiv = document.createElement('div');
        eventDiv.classList.add('event');
        eventDiv.innerText = eventForDay.title;
        daySquare.appendChild(eventDiv);
      }

      daySquare.addEventListener('click', () => openModal(dayString));
    } else {
      daySquare.classList.add('padding');
    }

document.getElementById('calendar').appendChild(daySquare);    
  }
}

function closeModal() {
  document.getElementById('eventTitleInput').classList.remove('error');
  document.getElementById('newEventModal').style.display = 'none';
  document.getElementById('deleteEventModal').style.display = 'none';
  document.getElementById('modalBackDrop').style.display = 'none';
  document.getElementById('eventTitleInput').value = '';
  clicked = null;
  load();
}

function saveEvent() {
  if (eventTitleInput.value) {
    eventTitleInput.classList.remove('error');

    events.push({
      date: clicked,
      title: eventTitleInput.value,
    });

    localStorage.setItem('events', JSON.stringify(events));
    closeModal();
  } else {
    eventTitleInput.classList.add('error');
  }
}

function deleteEvent() {
  events = events.filter(e => e.date !== clicked);
  localStorage.setItem('events', JSON.stringify(events));
  closeModal();
}

function next() {
document.getElementById('nav').value=document.getElementById('nav').value*1+1;
    load();
}

function back() {
document.getElementById('nav').value=document.getElementById('nav').value*1-1;
    load();
}


//document.getElementById('weekdays').