﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Player : MonoBehaviour 
{

	// Use this for initialization
	public bool Move(Vector2 direction) //izlaiž kustību diognāli
	{
		if (Mathf.Abs(direction.x) < 0.5) //vienmēr koordinātas būs 0
		{
			direction.x = 0;
		} 
			else 
		{
			direction.y = 0;
		}
		direction.Normalize(); //Vainu x vai y būs 1
		if (Blocked (transform.position, direction)) 
		{
			return false;
		}
			else 
		{
			transform.Translate(direction);
			return true;
		}
	}
		bool Blocked(Vector3 position, Vector2 direction) //sākuma pozīcija un virrziens
	{
		Vector2 newPos = new Vector2 (position.x, position.y) + direction;
		GameObject[] walls = GameObject.FindGameObjectsWithTag ("Wall");
		foreach (var wall in walls) 
		{
			if (wall.transform.position.x == newPos.x && wall.transform.position.y == newPos.y) 
				//ja siena eksistē uz kurieni grib kustēties, kustība nenotiks
			{
				return true;
			}
		}
		GameObject[] boxes = GameObject.FindGameObjectsWithTag ("Box");
		foreach (var box in boxes) 
		{
			if (box.transform.position.x == newPos.x && box.transform.position.y == newPos.y)
				//Ja kaste eksistē uz vierzienu kuru grib veikt kustību, persona pakustinās kasti
			{
				Box bx = box.GetComponent<Box>();
				if (bx && bx.Move(direction)) 	
				{
					return false;
				} 
				else 
				{
					return true;
				}	
			}
		}
		return false;
	}
}
