using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int[][] vietas = new int[][]
        {
            new int[] {0, 0, 0, 0, 0},      
            new int[] {0, 0, 0, 0, 0, 0, 0},
            new int[] {0, 0, 0, 0}          
        };

        List<string> rezervacijas = new List<string>();
        int izvele;

        do
        {
            Console.WriteLine("\n1 - Paradit zali");
            Console.WriteLine("2 - Rezervet vietu");
            Console.WriteLine("3 - Paradit rezervacijas");
            Console.WriteLine("4 - Iziet");
            Console.Write("Izvele: ");
            izvele = int.Parse(Console.ReadLine());

            switch (izvele)
            {
                case 1:
                    ParaditZali(vietas);
                    break;
                case 2:
                    RezervetVietu(vietas, rezervacijas);
                    break;
                case 3:
                    foreach (string r in rezervacijas)
                        Console.WriteLine(r);
                    if (rezervacijas.Count == 0)
                        Console.WriteLine("Nav rezervetu vietu.");
                    break;
                case 4:
                    Console.WriteLine("Izeja...");
                    break;
                default:
                    Console.WriteLine("Nepareiza izvele!");
                    break;
            }

        } while (izvele != 4);
    }

    static void ParaditZali(int[][] vietas)
    {
        for (int i = 0; i < vietas.Length; i++)
        {
            Console.Write($"Rinda {i + 1}: ");
            for (int j = 0; j < vietas[i].Length; j++)
            {
                Console.Write(vietas[i][j] == 0 ? "[O] " : "[X] ");
            }
            Console.WriteLine();
        }
    }

    static void RezervetVietu(int[][] vietas, List<string> rezervacijas)
    {
        Console.Write("Rindas numurs: ");
        int rinda = int.Parse(Console.ReadLine());
        Console.Write("Vietas numurs: ");
        int vieta = int.Parse(Console.ReadLine());

        if (rinda < 1 || rinda > vietas.Length)
        {
            Console.WriteLine("Nepareiza rinda!");
            return;
        }
        if (vieta < 1 || vieta > vietas[rinda - 1].Length)
        {
            Console.WriteLine("Nepareiza vieta!");
            return;
        }
        if (vietas[rinda - 1][vieta - 1] == 1)
        {
            Console.WriteLine("Vieta jau rezerveta!");
            return;
        }

        vietas[rinda - 1][vieta - 1] = 1;
        rezervacijas.Add($"Rinda {rinda}, Vieta {vieta}");
        Console.WriteLine("Vieta veiksmigi rezerveta!");
    }
}
