<?php
$dataFile = 'data.json';

// Read existing data
if (file_exists($dataFile)) {
    $data = json_decode(file_get_contents($dataFile), true);
} else {
    $data = [];
}

// Handle delete
if (isset($_GET['delete'])) {
    $index = $_GET['delete'];
    unset($data[$index]);
    $data = array_values($data);
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: action_page.php");
    exit;
}

// Handle edit
$editData = null;
if (isset($_GET['edit'])) {
    $index = $_GET['edit'];
    $editData = $data[$index];
}

// Handle form submission
if (isset($_POST['submit'])) {
    $entry = [
        'vards' => $_POST['vards'],
        'uzvards' => $_POST['uzvards'],
        'dzimdat' => $_POST['dzimdat'],
        'dzimums' => $_POST['dzimums'] ?? '',
        'gadi' => $_POST['gadi'] ?? '',
        'regions' => $_POST['regions'],
        'transports' => isset($_POST['transports']) ? implode(", ", $_POST['transports']) : ''
    ];

    if (isset($_POST['index']) && $_POST['index'] !== '') {
        $data[$_POST['index']] = $entry;
    } else {
        $data[] = $entry;
    }

    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: action_page.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
  <meta charset="UTF-8">
  <title>Datu ievade un tabula</title>
</head>
<body>

<h2>Personas dati</h2>

<form action="action_page.php" method="post">
  <input type="hidden" name="index" value="<?php echo isset($editData) ? $_GET['edit'] : ''; ?>">

  <label for="vards">Vārds:</label>
  <input type="text" id="vards" name="vards" value="<?php echo $editData['vards'] ?? ''; ?>" required><br>

  <label for="uzvards">Uzvārds:</label>
  <input type="text" id="uzvards" name="uzvards" value="<?php echo $editData['uzvards'] ?? ''; ?>" required><br>

  <label for="dzimdat">Dzimšanas datums:</label>
  <input type="date" id="dzimdat" name="dzimdat" value="<?php echo $editData['dzimdat'] ?? ''; ?>" required><br>

  <p>Dzimums:</p>
  <input type="radio" id="virietis" name="dzimums" value="Vīrietis" <?php if(($editData['dzimums'] ?? '')=='Vīrietis') echo 'checked'; ?>>
  <label for="virietis">Vīrietis</label><br>
  <input type="radio" id="sieviete" name="dzimums" value="Sieviete" <?php if(($editData['dzimums'] ?? '')=='Sieviete') echo 'checked'; ?>>
  <label for="sieviete">Sieviete</label><br>

  <p>Vecums:</p>
  <input type="radio" id="1" name="gadi" value="1-17" <?php if(($editData['gadi'] ?? '')=='1-17') echo 'checked'; ?>>
  <label for="1">1-17</label><br>
  <input type="radio" id="2" name="gadi" value="18-36" <?php if(($editData['gadi'] ?? '')=='18-36') echo 'checked'; ?>>
  <label for="2">18-36</label><br>
  <input type="radio" id="3" name="gadi" value="37-65+" <?php if(($editData['gadi'] ?? '')=='37-65+') echo 'checked'; ?>>
  <label for="3">37-65+</label><br><br>

  <label for="regions">Reģions:</label>
  <select name="regions" id="regions" required>
    <option value="">--Izvēlies reģionu--</option>
    <?php
      $regions = ["Kurzemes", "Zemgales", "Sēlijas", "Rīgas", "Vidzeme", "Latgale"];
      foreach ($regions as $r) {
          $selected = (($editData['regions'] ?? '') == $r) ? 'selected' : '';
          echo "<option value='$r' $selected>$r</option>";
      }
    ?>
  </select><br><br>

  <label>Transports:</label><br>
  <?php
    $options = ["Ritenis", "Kājas", "Mašīna", "Mocis", "Sabiedriskais transports", "Helikopters", "Cits"];
    $savedTransports = isset($editData['transports']) ? explode(", ", $editData['transports']) : [];
    foreach ($options as $opt) {
        $checked = in_array($opt, $savedTransports) ? 'checked' : '';
        echo "<input type='checkbox' name='transports[]' value='$opt' $checked> $opt<br>";
    }
  ?>

  <br>
  <input type="submit" name="submit" value="Saglabāt">
  <input type="reset" value="Notīrīt">
</form>

<h3>Ievadītie dati</h3>
<table border="1" cellpadding="5">
  <tr>
    <th>Vārds</th>
    <th>Uzvārds</th>
    <th>Dzimšanas datums</th>
    <th>Dzimums</th>
    <th>Vecums</th>
    <th>Reģions</th>
    <th>Transports</th>
    <th>Darbības</th>
  </tr>

  <?php foreach ($data as $index => $row): ?>
  <tr>
    <td><?php echo htmlspecialchars($row['vards']); ?></td>
    <td><?php echo htmlspecialchars($row['uzvards']); ?></td>
    <td><?php echo htmlspecialchars($row['dzimdat']); ?></td>
    <td><?php echo htmlspecialchars($row['dzimums']); ?></td>
    <td><?php echo htmlspecialchars($row['gadi']); ?></td>
    <td><?php echo htmlspecialchars($row['regions']); ?></td>
    <td><?php echo htmlspecialchars($row['transports']); ?></td>
    <td>
      <a href="action_page.php?edit=<?php echo $index; ?>">Labot</a> |
      <a href="action_page.php?delete=<?php echo $index; ?>" onclick="return confirm('Dzēst šo ierakstu?');">Dzēst</a>
    </td>
  </tr>
  <?php endforeach; ?>
</table>

</body>
</html>
