using System;
using System.Collections.Generic;
using System.Linq;
enum Tips {Mape, Datne}
class FileSystem
{
public string Nosaukums {get; set;}
public FileSystem Vecaks {get; set;}
public List<FileSystem> berni {get; set;} = new List <FileSystem>(); //izveidojas list sarakstu ar klasi FileSystem (site)
public Tips Tips { get; set; }

public FileSystem(string nosaukums, Tips tips, FileSystem vecaks = null)//konstruktos
{//pieskriam parametrus mainigajos
Nosaukums = nosaukums;
Tips = tips;
Vecaks = vecaks;
}
public void Paradit()//neatgriezama metode, izvada simbolus saistosus ar datni
{
if(Tips == Tips.Datne)
{
Console.WriteLine("/~" + Nosaukums + "~");
}
else
{
foreach (var berns in berni)//iziet caur mainigo berni caur foreach ciklu
{
if (berns.Tips == Tips.Datne)
Console.WriteLine("/~" + berns.Nosaukums + "~");
else
Console.WriteLine("/[" + berns.Nosaukums + "]");
}
}
}
public void Izveidot(string nosaukums, Tips tips)//neatgriezama metode
{
//Pārbauda, vai kolekcijā berni ir vismaz viens elements, kura Nosaukums ir tāds pats kā mainīgajam nosaukums, ignorējot burtu reģistru
if (berni.Any(b => b.Nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase)))//https://learn.microsoft.com/en-us/dotnet/api/system.object.equals?view=net-9.0
{
Console.WriteLine("Objekts ar sadu nosaukumu jau eksiste.");
return;
}
berni.Add(new FileSystem(nosaukums, tips, this));//pievieno jaunu FileSystem objektu kolekcijai berni.()
}
// Publiska metode, kas dzēš bērna objektu pēc tā nosaukuma
public void Dzest(string nosaukums)
{
// Atrodam pirmo bērnu kolekcijā, kura Nosaukums atbilst dotajam (ignorējot reģistru)
var objekts = berni.FirstOrDefault(b => b.Nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase));//https://learn.microsoft.com/en-us/dotnet/api/system.object.equals?view=net-9.0
// Ja objekts nav atrasts, izvadām ziņu un beidzam darbu
if (objekts == null)
{
Console.WriteLine("Objekts nav atrasts.");
return;
}
//Ja objekts ir mape un tajā ir citi bērni, jautājam apstiprinājumu lietotājam
if (objekts.Tips == Tips.Mape && objekts.berni.Any())//site
{
Console.Write($"Mape '{nosaukums}' satur objektus. Vai tiesam dzest? (j/n): ");
var atbilde = Console.ReadLine().ToLower();
// Ja lietotājs neapstiprina ar "j", pārtraucam dzēšanu
if (atbilde != "j")
{
Console.WriteLine("dzesana atcelta.");
return;
}
}
// Izdzēšam atrasto objektu no bērnu saraksta
berni.Remove(objekts);//https://www.geeksforgeeks.org/c-sharp-string-remove-method/
Console.WriteLine($"Objekts '{nosaukums}' ir izdzests.");
}
// Publiska metode, kas atgriež bērnu (mapi) ar norādīto nosaukumu
public FileSystem Iegutbernu(string nosaukums)
{
// Mēģinām atrast pirmo bērnu kolekcijā, kura nosaukums atbilst dotajam un tips ir 'Mape'
return berni.FirstOrDefault(b => b.Nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase) && b.Tips == Tips.Mape);
}
// Publiska metode, kas mēģina atrast un izvadīt datni ar norādīto nosaukumu
public void Edit(string datnesNosaukums)
{
// Mēģinām atrast pirmo bērnu kolekcijā, kura nosaukums atbilst dotajam un tips ir 'Datne'
var datne = berni.FirstOrDefault(b => b.Nosaukums.Equals(datnesNosaukums, StringComparison.OrdinalIgnoreCase) && b.Tips == Tips.Datne);//https://learn.microsoft.com/en-us/dotnet/api/system.object.equals?view=net-9.0
//https://learn.microsoft.com/en-us/dotnet/api/system.stringcomparer.ordinalignorecase?view=net-9.0
// Ja datne tika atrasta (datne nav null), izvadām tās nosaukumu
if (datne != null)
{
Console.WriteLine($"Datne: /~{datne.Nosaukums}~");
}
else
{
Console.WriteLine("Datne nav atrasta.");
}
}
// Publiska metode, kas atgriež faila vai mapes ceļu, pamatojoties uz hierarhiju
public string IegutCelu()
{
// Ja Vecaks ir null (tātad šis objekts ir saknes elements), atgriež tikai nosaukumu ar sākuma ceļu ":/"
return Vecaks == null ? Nosaukums + ":/" : Vecaks.IegutCelu() + Nosaukums + "/";

}
}
public class HelloWorld
{
public static void Main(string[] args)
{
var sakums = new FileSystem("c", Tips.Mape); //izveido objektu failu sistemas klasei
var now = sakums; // mainigam pieskiram iprieksejo mainigo
//while cikls, kas prasis un izsauks nepieciesamo
while (true)
{

Console.Write(now.IegutCelu() + "> ");//izvadisana uzsaucot metodi
var ievade = Console.ReadLine().Trim();//Izmantojot metodi Trim(), lai no virknes noņemtu sākuma un beigu atstarpes.
if (ievade == null || ievade == "") continue;//Izmantojot IsNullOrEmpty(), lai pārbaudītu, vai virkne ir Null vai tukša.
var dalas = ievade.Split(' ');//site
var komanda = dalas[0].ToLower();//site
var arguments = dalas.Length > 1 ? dalas[1] : "";
//switch cikls kas ies caur izsauktam metodem
try
{
switch (komanda)
{
case "mkdir"://piesaista objektam jaunu mapi
{
if (arguments != null && arguments.Length > 0)
now.Izveidot(arguments, Tips.Mape);//izsaucam metodi un parametros ievadam argumentu un enum Tipu kas izsauc Mapi
break;
}
case "create"://piesaista objektam jaunu datni
{
if (arguments != null && arguments.Length > 0)//site
now.Izveidot(arguments, Tips.Datne);//tad mes caur to pasu metodi izsaucam enum Tips - datne
break;
}
case "rm"://dzēš mapi
{
if (arguments != null && arguments.Length > 0)//site
now.Dzest(arguments);
break;
}
case "dir"://parada bernus
{
now.Paradit();
break;
}
case "cd"://pārvietojas uz mapi, ja ir mape , vai paziņojums
{
if (arguments == "..")//parbaude vai ievade bus ..
{
if (now.Vecaks != null)//ja vecaks nav null tad pieskiram jaunu vertibu now
now = now.Vecaks;
}
else//citadi
{
var next = now.Iegutbernu(arguments);//mainiga pieskiram metodi iegut bernu
if (next != null)
now = next;
else
Console.WriteLine("Mape nav atrasta.");
}
break;
}
case "edit"://parāda datnes nosaukumu
{
if (arguments != null && arguments.Length > 0)//site
now.Edit(arguments);
break;
}
case "exit":
case "by":
return;

default:
Console.WriteLine("Nezinama komanda.");
break;

}
}
catch (Exception e)
{
Console.WriteLine("Ir atrasta kļūda.");
}
}
}
}
