using System;

class Program
{
    static void Main(string[] args)
    {
        string vards = "Eliz";
        string uzvards = "Virsica";

        // Izveidojam sākotnējo masīvu ar datiem
        int[,] dati = TabulasDati(vards, uzvards);

        // Izvada galveni ar vārdu
        TabulasGalva(vards);

        // Izvada pašu tabulu ar datiem
        Tabula(dati, uzvards);

        Console.WriteLine();
        Console.WriteLine("Apgriezta tabula:");

        // Apmainam rindu un kolonnu vietām
        int[,] apgriezts = TabulasMaina(dati);

        // Atkārtoti izvada galveni un apgriezto tabulu
        TabulasGalva(vards);
        Tabula(apgriezts, uzvards);
    }

    // Funkcija, kas ģenerē 2D masīvu pēc vārda un uzvārda
    static int[,] TabulasDati(string vards, string uzvards)
    {
        int rindas = uzvards.Length;
        int kolonnas = vards.Length;

        int min = vards.Length;
        int max = vards.Length + uzvards.Length;

        Random rnd = new Random();
        int[,] masivs = new int[rindas, kolonnas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                masivs[i, j] = rnd.Next(min, max + 1);
            }
        }

        return masivs;
    }

    // Izvada galveni ar vārdu burtiem un Max, Min, Sum kolonnām
    static void TabulasGalva(string vards)
    {
        int kopSkaits = 1 + vards.Length + 3;

        TabulasLinija(kopSkaits);

        Console.Write("|     ");
        foreach (char burts in vards)
        {
            Console.Write($"| {burts,3} ");
        }
        Console.Write("|Max  |Min  |Sum  |");
        Console.WriteLine();

        TabulasLinija(kopSkaits);
    }

    // Izvada tabulu ar rindām un aprēķina statistiku
    static void Tabula(int[,] masivs, string uzvards)
    {
        int rindas = masivs.GetLength(0);
        int kolonnas = masivs.GetLength(1);
        int kopSkaits = 1 + kolonnas + 3;

        for (int i = 0; i < rindas; i++)
        {
            int[] rinda = new int[kolonnas];
            for (int j = 0; j < kolonnas; j++)
            {
                rinda[j] = masivs[i, j];
            }

            int max = rinda[0];
            int min = rinda[0];
            int sum = 0;

            foreach (int sk in rinda)
            {
                if (sk > max) max = sk;
                if (sk < min) min = sk;
                sum += sk;
            }

            char kreisais = i < uzvards.Length ? uzvards[i] : ' ';
            TabulasRinda(kreisais, rinda, max, min, sum);

            TabulasLinija(kopSkaits);
        }
    }

    // Rāda vienu rindu ar datiem un statistiku
    static void TabulasRinda(char burts, int[] dati, int max, int min, int sum)
    {
        Console.Write($"|  {burts}  ");
        for (int i = 0; i < dati.Length; i++)
        {
            Console.Write($"| {dati[i],3} ");
        }
        Console.Write($"| {max,3} | {min,3} | {sum,3} |");
        Console.WriteLine();
    }

    // Izvada līniju ar +-----+
    static void TabulasLinija(int skaits)
    {
        for (int i = 0; i < skaits; i++)
        {
            Console.Write("+-----");
        }
        Console.WriteLine("+");
    }

    // Apmaina rindu un kolonnu vietām
    static int[,] TabulasMaina(int[,] masivs)
    {
        int rindas = masivs.GetLength(0);
        int kolonnas = masivs.GetLength(1);

        int[,] jauns = new int[kolonnas, rindas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                jauns[j, i] = masivs[i, j];
            }
        }

        return jauns;
    }
}
