using System;
using System.Collections.Generic;

// Klase, kas parstav bankas kontu
class BankasKonts
{
    private static int skaititajs = 1000;
    private int kontaNumurs;
    private string vards;
    private decimal atlikums;
    public int KontaNumurs => kontaNumurs;

    // Konstruktors konta izveidei
    public BankasKonts(string v, decimal a)
    {
        kontaNumurs = ++skaititajs;
        vards = v;
        atlikums = a >= 0 ? a : 0;
        if (a < 0)
        {
            Console.WriteLine("Sakuma atlikums nevar but negativs. Iestatits uz 0.");
        }
    }

    // Funkcija naudas noguldisanai
    public void Noguldit(decimal summa)
    {
        if (summa > 0)
        {
            atlikums += summa;
            Console.WriteLine("Nogulditi " + summa + " EUR konta #" + kontaNumurs);
        }
        else
        {
            Console.WriteLine("Kluda: nedrikst noguldit negativu summu.");
        }
    }

    // Funkcija naudas iznemsanai
    public void Iznemt(decimal summa)
    {
        if (summa > 0)
        {
            if (summa <= atlikums)
            {
                atlikums -= summa;
                Console.WriteLine("Iznemti " + summa + " EUR no konta #" + kontaNumurs);
            }
            else
            {
                Console.WriteLine("Kluda: nepietiek lidzeklu.");
            }
        }
        else
        {
            Console.WriteLine("Kluda: summa nevar but negativa.");
        }
    }

    // Parada konta informaciju
    public void Info()
    {
        Console.WriteLine("--- Konta informacija ---");
        Console.WriteLine("Konta numurs: " + kontaNumurs);
        Console.WriteLine("Ipasnieks: " + vards);
        Console.WriteLine("Atlikums: " + atlikums + " EUR");
        Console.WriteLine("-------------------------");
    }
}

// Galvena programma
class Programma
{
    static List<BankasKonts> konti = new List<BankasKonts>();

    // Galvena metode
    static void Main(string[] args)
    {
        bool turpina = true;

        while (turpina)
        {
            // Izveles menju
            Console.WriteLine("\nLudzu, izvelejieties darbibu:");
            Console.WriteLine("1. Izveidot jaunu bankas kontu");
            Console.WriteLine("2. Noguldit naudu konta");
            Console.WriteLine("3. Iznemt naudu no konta");
            Console.WriteLine("4. Paradit konta informaciju");
            Console.WriteLine("5. Dzest kontu");
            Console.WriteLine("6. Iziet no sistemas");
            Console.Write("Jusu izvele: ");
            string izvele = Console.ReadLine();

            // Menju izpilde
            switch (izvele)
            {
                case "1":
                    IzveidotKontu();
                    break;
                case "2":
                    NaudasDarbiba("noguldit");
                    break;
                case "3":
                    NaudasDarbiba("iznemt");
                    break;
                case "4":
                    ParaditInformaciju();
                    break;
                case "5":
                    DzestKontu();
                    break;
                case "6":
                    turpina = false;
                    Console.WriteLine("Iziet no sistemas...");
                    break;
                default:
                    Console.WriteLine("Nederiga izvele. Meginiet velreiz.");
                    break;
            }
        }

        Console.WriteLine("Nospiediet jebkuru taustinu, lai izietu.");
        Console.ReadKey();
    }

    // Jauna konta izveide
    static void IzveidotKontu()
    {
        Console.Write("Ievadiet ipasnieka vardu: ");
        string vards = Console.ReadLine();

        Console.Write("Ievadiet sakuma atlikumu: ");
        decimal atlikums = Convert.ToDecimal(Console.ReadLine());

        BankasKonts konts = new BankasKonts(vards, atlikums);
        konti.Add(konts);

        Console.WriteLine("Konts izveidots ar numuru: " + konts.KontaNumurs);
    }

    // Noguldisana vai iznemsana
    static void NaudasDarbiba(string veids)
    {
        BankasKonts konts = MekletKontu();
        if (konts == null) return;

        Console.Write("Ievadiet summu, ko " + veids + ": ");
        decimal summa = Convert.ToDecimal(Console.ReadLine());

        if (veids == "noguldit")
            konts.Noguldit(summa);
        else if (veids == "iznemt")
            konts.Iznemt(summa);
    }

    // Konta informacijas paradisana
    static void ParaditInformaciju()
    {
        BankasKonts konts = MekletKontu();
        if (konts != null)
        {
            konts.Info();
        }
    }

    // Konta dzesana
    static void DzestKontu()
    {
        BankasKonts konts = MekletKontu();
        if (konts != null)
        {
            konti.Remove(konts);
            Console.WriteLine("Konts veiksmigi dzests.");
        }
    }

    // Mekle kontu pec numura
    static BankasKonts MekletKontu()
    {
        Console.Write("Ievadiet konta numuru: ");
        if (int.TryParse(Console.ReadLine(), out int numurs))
        {
            BankasKonts konts = konti.Find(k => k.KontaNumurs == numurs);
            if (konts == null)
                Console.WriteLine("Konts nav atrasts.");
            return konts;
        }
        else
        {
            Console.WriteLine("Kluda: ievadits nederigs numurs.");
            return null;
        }
    }
}
