<?php
include "conn.php"; 

$data = [];
$sql = "SELECT id, vards, uzvards, datums, izvele, paraleles, dzimums FROM $table_name ORDER BY id DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Ierakstu Saraksts</title>
    <style>
        table { border-collapse: collapse; width: 80%; margin: 20px auto; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
<h2>Ierakstu saraksts</h2>

<p><a href="ievade.php"><button>Jauns (Pievienot jaunu ierakstu)</button></a></p>

<table border="1">
    <tr>
        <th>ID</th>
        <th>Vārds</th>
        <th>Uzvārds</th>
        <th>Datums</th>
        <th>Izvēle</th>
        <th>Paralēlās izvēles</th>
        <th>Dzimums</th>
        <th>Darbības</th>
    </tr>
    <?php if (empty($data)): ?>
        <tr><td colspan="8">Nav atrasti ieraksti.</td></tr>
    <?php else: ?>
        <?php foreach ($data as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['id']) ?></td>
            <td><?= htmlspecialchars($row['vards']) ?></td>
            <td><?= htmlspecialchars($row['uzvards']) ?></td>
            <td><?= htmlspecialchars($row['datums']) ?></td>
            <td><?= htmlspecialchars($row['izvele']) ?></td>
            <td><?= htmlspecialchars($row['paraleles']) ?></td>
            <td><?= htmlspecialchars($row['dzimums']) ?></td>
            <td>
                <form method="get" action="ievade.php" style="display:inline">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button type="submit">Labot</button>
                </form>

                <form method="get" action="delete.php" style="display:inline" onsubmit="return confirm('Vai tiešām dzēst šo ierakstu?');">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button type="submit">Dzēst</button>
                </form>
            </td>
        </tr>
        <?php endforeach; ?>
    <?php endif; ?>
</table>
</body>
</html>