<?php
$dataFile = 'data.json';
if (!file_exists($dataFile)) {
    file_put_contents($dataFile, json_encode([]));
}

$data = json_decode(file_get_contents($dataFile), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['delete'])) {
        $index = $_POST['delete'];
        if (isset($data[$index])) {
            unset($data[$index]);
            $data = array_values($data);
            file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
    } else {
        $data[] = [
            'vards' => $_POST['vards'],
            'uzvards' => $_POST['uzvards'],
            'datums' => $_POST['datums'],
            'izvele' => $_POST['izvele'],
            'paraleles' => isset($_POST['paraleles']) ? implode(',', $_POST['paraleles']) : '',
            'dzimums' => $_POST['dzimums']
        ];
        file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Forma un tabula</title>
</head>
<body>
<h2>Jauns ieraksts</h2>
<form method="post">
    Vārds: <input type="text" name="vards" required><br>
    Uzvārds: <input type="text" name="uzvards" required><br>
    Datums: <input type="date" name="datums" required><br>
    Izvēle: 
    <select name="izvele">
        <option value="1">Izvēle 1</option>
        <option value="2">Izvēle 2</option>
    </select><br>
    Paralēlās izvēles:<br>
    <input type="checkbox" name="paraleles[]" value="A"> A
    <input type="checkbox" name="paraleles[]" value="B"> B<br>
    Dzimums:<br>
    <input type="radio" name="dzimums" value="Vīrietis" required> Vīrietis
    <input type="radio" name="dzimums" value="Sieviete"> Sieviete<br><br>
    <input type="submit" value="Saglabāt">
    <input type="reset" value="Notīrīt">
</form>

<h2>Ierakstu saraksts</h2>
<table border="1">
    <tr>
        <th>Vārds</th>
        <th>Uzvārds</th>
        <th>Datums</th>
        <th>Izvēle</th>
        <th>Paralēlās izvēles</th>
        <th>Dzimums</th>
        <th>Darbības</th>
    </tr>
    <?php foreach ($data as $index => $row): ?>
    <tr>
        <td><?= htmlspecialchars($row['vards']) ?></td>
        <td><?= htmlspecialchars($row['uzvards']) ?></td>
        <td><?= htmlspecialchars($row['datums']) ?></td>
        <td><?= htmlspecialchars($row['izvele']) ?></td>
        <td><?= htmlspecialchars($row['paraleles']) ?></td>
        <td><?= htmlspecialchars($row['dzimums']) ?></td>
        <td>
            <form method="post" style="display:inline">
                <button type="submit" name="delete" value="<?= $index ?>">Dzēst</button>
            </form>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
</body>
</html>